/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.timestamp.storage;

import com.google.common.base.Charsets;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.timestamp.storage.HBaseTimestampStorageConfig;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTimestampStorage
implements TimestampStorage {
    private static final long INITIAL_MAX_TS_VALUE = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimestampStorage.class);
    private static final byte[] TSO_ROW = "MAX_TIMESTAMP_R".getBytes(Charsets.UTF_8);
    private static final byte[] TSO_QUALIFIER = "MAX_TIMESTAMP_Q".getBytes(Charsets.UTF_8);
    private final Table table;
    private final byte[] cfName;
    private final Connection connection;

    @Inject
    public HBaseTimestampStorage(Configuration hbaseConfig, HBaseTimestampStorageConfig config) throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)hbaseConfig);
        this.table = this.connection.getTable(TableName.valueOf((String)config.getTableName()));
        this.cfName = config.getFamilyName().getBytes(Charsets.UTF_8);
    }

    @Override
    public void updateMaxTimestamp(long previousMaxTimestamp, long newMaxTimestamp) throws IOException {
        if (newMaxTimestamp < 0L) {
            LOG.error("Negative value received for maxTimestamp: {}", (Object)newMaxTimestamp);
            throw new IllegalArgumentException("Negative value received for maxTimestamp" + newMaxTimestamp);
        }
        Put put = new Put(TSO_ROW);
        put.addColumn(this.cfName, TSO_QUALIFIER, Bytes.toBytes((long)newMaxTimestamp));
        byte[] previousVal = null;
        if (previousMaxTimestamp != 0L) {
            previousVal = Bytes.toBytes((long)previousMaxTimestamp);
        }
        if (!this.table.checkAndPut(TSO_ROW, this.cfName, TSO_QUALIFIER, previousVal, put)) {
            throw new IOException("Previous max timestamp is incorrect");
        }
    }

    @Override
    public long getMaxTimestamp() throws IOException {
        Get get = new Get(TSO_ROW);
        get.addColumn(this.cfName, TSO_QUALIFIER);
        Result result = this.table.get(get);
        if (result.containsColumn(this.cfName, TSO_QUALIFIER)) {
            return Bytes.toLong((byte[])result.getValue(this.cfName, TSO_QUALIFIER));
        }
        return 0L;
    }

    public void close() throws IOException {
        this.table.close();
        this.connection.close();
    }
}

