/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.Counter;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.metrics.Timer;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.transaction.TransactionManager;
import org.apache.omid.transaction.TransactionManagerException;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.omid.tso.client.ServiceUnavailableException;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.hash.Hashing;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionManager
implements TransactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionManager.class);
    private final PostCommitActions postCommitter;
    protected final TSOProtocol tsoClient;
    protected final CommitTable.Client commitTableClient;
    private final CommitTable.Writer commitTableWriter;
    private final TransactionFactory<? extends CellId> transactionFactory;
    private final Timer startTimestampTimer;
    private final Timer commitTimer;
    private final Timer fenceTimer;
    private final Counter committedTxsCounter;
    private final Counter rolledbackTxsCounter;
    private final Counter errorTxsCounter;
    private final Counter invalidatedTxsCounter;

    public AbstractTransactionManager(MetricsRegistry metrics, PostCommitActions postCommitter, TSOProtocol tsoClient, CommitTable.Client commitTableClient, CommitTable.Writer commitTableWriter, TransactionFactory<? extends CellId> transactionFactory) {
        this.tsoClient = tsoClient;
        this.postCommitter = postCommitter;
        this.commitTableClient = commitTableClient;
        this.commitTableWriter = commitTableWriter;
        this.transactionFactory = transactionFactory;
        this.startTimestampTimer = metrics.timer(MetricsUtils.name("omid", "tm", "hbase", "startTimestamp", "latency"));
        this.commitTimer = metrics.timer(MetricsUtils.name("omid", "tm", "hbase", "commit", "latency"));
        this.fenceTimer = metrics.timer(MetricsUtils.name("omid", "tm", "hbase", "fence", "latency"));
        this.committedTxsCounter = metrics.counter(MetricsUtils.name("omid", "tm", "hbase", "committedTxs"));
        this.rolledbackTxsCounter = metrics.counter(MetricsUtils.name("omid", "tm", "hbase", "rolledbackTxs"));
        this.errorTxsCounter = metrics.counter(MetricsUtils.name("omid", "tm", "hbase", "erroredTxs"));
        this.invalidatedTxsCounter = metrics.counter(MetricsUtils.name("omid", "tm", "hbase", "invalidatedTxs"));
    }

    public void preBegin() throws TransactionManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Transaction begin() throws TransactionException {
        try {
            long startTimestamp;
            long epoch;
            this.preBegin();
            this.startTimestampTimer.start();
            try {
                do {
                    startTimestamp = (Long)this.tsoClient.getNewStartTimestamp().get();
                } while ((epoch = this.tsoClient.getEpoch()) > startTimestamp);
            }
            finally {
                this.startTimestampTimer.stop();
            }
            AbstractTransaction<? extends CellId> tx = this.transactionFactory.createTransaction(startTimestamp, epoch, this);
            this.postBegin(tx);
            return tx;
        }
        catch (TransactionManagerException e) {
            throw new TransactionException("An error has occured during PreBegin/PostBegin", e);
        }
        catch (ExecutionException e) {
            throw new TransactionException("Could not get new timestamp", e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TransactionException("Interrupted getting timestamp", ie);
        }
    }

    public abstract long getHashForTable(byte[] var1);

    public CommitTable.Client getCommitTableClient() {
        return this.commitTableClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Transaction fence(byte[] tableName) throws TransactionException {
        long tableID = this.getHashForTable(tableName);
        Hashing.murmur3_128().newHasher().putBytes(tableName).hash().asLong();
        try {
            long fenceTimestamp;
            this.fenceTimer.start();
            try {
                fenceTimestamp = (Long)this.tsoClient.getFence(tableID).get();
            }
            finally {
                this.fenceTimer.stop();
            }
            AbstractTransaction<? extends CellId> tx = this.transactionFactory.createTransaction(fenceTimestamp, fenceTimestamp, this);
            return tx;
        }
        catch (ExecutionException e) {
            throw new TransactionException("Could not get fence", e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TransactionException("Interrupted creating a fence", ie);
        }
    }

    public void postBegin(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
    }

    public void preCommit(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
    }

    @Override
    public final void commit(Transaction transaction) throws RollbackException, TransactionException {
        AbstractTransaction<? extends CellId> tx = this.enforceAbstractTransactionAsParam(transaction);
        this.enforceTransactionIsInRunningState(tx);
        if (tx.isRollbackOnly()) {
            this.rollback(tx);
            throw new RollbackException(tx + ": Tx was set to rollback explicitly");
        }
        try {
            this.preCommit(tx);
            this.commitTimer.start();
            try {
                if (tx.getWriteSet().isEmpty() && tx.getConflictFreeWriteSet().isEmpty()) {
                    this.markReadOnlyTransaction(tx);
                } else if (this.tsoClient.isLowLatency()) {
                    this.commitLowLatencyTransaction(tx);
                } else {
                    this.commitRegularTransaction(tx);
                }
                this.committedTxsCounter.inc();
            }
            finally {
                this.commitTimer.stop();
            }
            this.postCommit(tx);
        }
        catch (TransactionManagerException e) {
            throw new TransactionException(e.getMessage(), e);
        }
    }

    public void postCommit(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
    }

    public void preRollback(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
    }

    @Override
    public final void rollback(Transaction transaction) throws TransactionException {
        AbstractTransaction<? extends CellId> tx = this.enforceAbstractTransactionAsParam(transaction);
        this.enforceTransactionIsInRunningState(tx);
        try {
            this.preRollback(tx);
            tx.setCommitTimestamp(0L);
            tx.setStatus(Transaction.Status.ROLLEDBACK);
            this.postRollback(tx);
        }
        catch (TransactionManagerException e) {
            throw new TransactionException(e.getMessage(), e);
        }
        finally {
            tx.cleanup();
        }
    }

    public void postRollback(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
    }

    protected abstract void closeResources() throws IOException;

    @Override
    public final void close() throws IOException {
        this.tsoClient.close();
        this.closeResources();
    }

    private void enforceTransactionIsInRunningState(Transaction transaction) {
        if (transaction.getStatus() != Transaction.Status.RUNNING) {
            throw new IllegalArgumentException("Transaction was already " + (Object)((Object)transaction.getStatus()));
        }
    }

    private AbstractTransaction<? extends CellId> enforceAbstractTransactionAsParam(Transaction tx) {
        if (tx instanceof AbstractTransaction) {
            return (AbstractTransaction)tx;
        }
        throw new IllegalArgumentException("The transaction object passed is not an instance of AbstractTransaction");
    }

    private void markReadOnlyTransaction(AbstractTransaction<? extends CellId> readOnlyTx) {
        readOnlyTx.setStatus(Transaction.Status.COMMITTED_RO);
    }

    private void commitLowLatencyTransaction(AbstractTransaction<? extends CellId> tx) throws RollbackException, TransactionException {
        try {
            long commitTs = (Long)this.tsoClient.commit(tx.getStartTimestamp(), tx.getWriteSet(), tx.getConflictFreeWriteSet()).get();
            boolean committed = this.commitTableWriter.atomicAddCommittedTransaction(tx.getStartTimestamp(), commitTs);
            if (!committed) {
                this.rollback(tx);
                this.commitTableClient.deleteCommitEntry(tx.getStartTimestamp());
                this.rolledbackTxsCounter.inc();
                throw new RollbackException("Transaction " + tx.getTransactionId() + " got invalidated");
            }
            this.certifyCommitForTx(tx, commitTs);
            this.updateShadowCellsAndRemoveCommitTableEntry(tx, this.postCommitter);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AbortException) {
                this.rollback(tx);
                this.rolledbackTxsCounter.inc();
                throw new RollbackException(tx.getStartTimestamp() + ": Conflicts detected in writeset", e.getCause());
            }
            if (e.getCause() instanceof ServiceUnavailableException || e.getCause() instanceof ConnectionException) {
                this.errorTxsCounter.inc();
                this.rollback(tx);
                throw new RollbackException(tx.getStartTimestamp() + " rolled-back precautionary", e.getCause());
            }
            throw new TransactionException(tx.getStartTimestamp() + ": cannot determine Tx outcome", e.getCause());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void commitRegularTransaction(AbstractTransaction<? extends CellId> tx) throws RollbackException, TransactionException {
        try {
            long commitTs = (Long)this.tsoClient.commit(tx.getStartTimestamp(), tx.getWriteSet(), tx.getConflictFreeWriteSet()).get();
            this.certifyCommitForTx(tx, commitTs);
            this.updateShadowCellsAndRemoveCommitTableEntry(tx, this.postCommitter);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AbortException) {
                this.rollback(tx);
                this.rolledbackTxsCounter.inc();
                throw new RollbackException(tx.getStartTimestamp() + ": Conflicts detected in writeset", e.getCause());
            }
            if (e.getCause() instanceof ServiceUnavailableException || e.getCause() instanceof ConnectionException) {
                this.errorTxsCounter.inc();
                try {
                    LOG.warn("Can't contact the TSO for receiving outcome for Tx {}. Checking Commit Table...", (Object)tx.getStartTimestamp());
                    Optional commitTimestamp = (Optional)this.commitTableClient.getCommitTimestamp(tx.getStartTimestamp()).get();
                    if (commitTimestamp.isPresent()) {
                        if (((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid()) {
                            LOG.warn("{}: Valid commit TS found in Commit Table. Committing Tx...", (Object)tx.getStartTimestamp());
                            this.certifyCommitForTx(tx, ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue());
                            this.postCommitter.updateShadowCells(tx);
                        }
                        LOG.warn("{}: Invalidated commit TS found in Commit Table. Rolling-back...", (Object)tx.getStartTimestamp());
                        this.rollback(tx);
                        throw new RollbackException(tx.getStartTimestamp() + " invalidated by other Tx started", e.getCause());
                    }
                    LOG.warn("{}: Trying to invalidate Tx proactively in Commit Table...", (Object)tx.getStartTimestamp());
                    boolean invalidated = (Boolean)this.commitTableClient.tryInvalidateTransaction(tx.getStartTimestamp()).get();
                    if (invalidated) {
                        LOG.warn("{}: Invalidated proactively in Commit Table. Rolling-back Tx...", (Object)tx.getStartTimestamp());
                        this.invalidatedTxsCounter.inc();
                        this.rollback(tx);
                        throw new RollbackException(tx.getStartTimestamp() + " rolled-back precautionary", e.getCause());
                    }
                    LOG.warn("{}: Invalidation could NOT be completed. Re-checking Commit Table...", (Object)tx.getStartTimestamp());
                    commitTimestamp = (Optional)this.commitTableClient.getCommitTimestamp(tx.getStartTimestamp()).get();
                    if (commitTimestamp.isPresent() && ((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid()) {
                        LOG.warn("{}: Valid commit TS found in Commit Table. Committing Tx...", (Object)tx.getStartTimestamp());
                        this.certifyCommitForTx(tx, ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue());
                        this.postCommitter.updateShadowCells(tx);
                    }
                    LOG.error("{}: Can't determine Transaction outcome", (Object)tx.getStartTimestamp());
                    throw new TransactionException(tx.getStartTimestamp() + ": cannot determine Tx outcome");
                }
                catch (ExecutionException e1) {
                    throw new TransactionException(tx.getStartTimestamp() + ": problem reading commitTS from Commit Table", e1);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new TransactionException(tx.getStartTimestamp() + ": interrupted while reading commitTS from Commit Table", e1);
                }
            }
            throw new TransactionException(tx.getStartTimestamp() + ": cannot determine Tx outcome", e.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TransactionException(tx.getStartTimestamp() + ": interrupted during commit", ie);
        }
    }

    private void updateShadowCellsAndRemoveCommitTableEntry(final AbstractTransaction<? extends CellId> tx, final PostCommitActions postCommitter) {
        Futures.transform(postCommitter.updateShadowCells(tx), (Function)new Function<Void, Void>(){

            public Void apply(Void aVoid) {
                postCommitter.removeCommitTableEntry(tx);
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void certifyCommitForTx(AbstractTransaction<? extends CellId> txToSetup, long commitTS) {
        txToSetup.setStatus(Transaction.Status.COMMITTED);
        txToSetup.setCommitTimestamp(commitTS);
    }

    public boolean isLowLatency() {
        return this.tsoClient.isLowLatency();
    }

    public static interface TransactionFactory<T extends CellId> {
        public AbstractTransaction<T> createTransaction(long var1, long var3, AbstractTransactionManager var5);
    }
}

