/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.apache.omid.TestUtils;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOClientRowAndCellLevelConflict {
    private static final Logger LOG = LoggerFactory.getLogger(TestTSOClientRowAndCellLevelConflict.class);
    private static final String TSO_SERVER_HOST = "localhost";
    private static final int TSO_SERVER_PORT = 5678;
    private OmidClientConfiguration tsoClientConf;
    private TSOServer tsoServer;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setConflictMapSize(1000);
        tsoConfig.setPort(5678);
        tsoConfig.setNumConcurrentCTWriters(2);
        TSOMockModule tsoServerMockModule = new TSOMockModule(tsoConfig);
        Injector injector = Guice.createInjector((Module[])new Module[]{tsoServerMockModule});
        LOG.info("==================================================================================================");
        LOG.info("======================================= Init TSO Server ==========================================");
        LOG.info("==================================================================================================");
        this.tsoServer = (TSOServer)((Object)injector.getInstance(TSOServer.class));
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_SERVER_HOST, 5678, 100);
        LOG.info("==================================================================================================");
        LOG.info("===================================== TSO Server Initialized =====================================");
        LOG.info("==================================================================================================");
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:5678");
        this.tsoClientConf = tsoClientConf;
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_SERVER_HOST, 5678, 1000);
    }

    @Test(timeOut=30000L)
    public void testRowLevelConflictAnalysisConflict() throws Exception {
        this.tsoClientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(4276996862L, 3735928558L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)client.getNewStartTimestamp().get();
        long ts2 = (Long)client.getNewStartTimestamp().get();
        client.commit(ts1, testWriteSet1).get();
        try {
            client.commit(ts2, testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AbortException), (String)"Transaction should be aborted");
            return;
        }
        Assert.assertTrue((boolean)false, (String)"Transaction should be aborted");
    }

    @Test(timeOut=30000L)
    public void testRowLevelConflictAnalysisCommit() throws Exception {
        this.tsoClientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(4276996862L, 3735928559L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)client.getNewStartTimestamp().get();
        long ts2 = (Long)client.getNewStartTimestamp().get();
        client.commit(ts1, testWriteSet1).get();
        try {
            client.commit(ts2, testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertFalse((boolean)(e.getCause() instanceof AbortException), (String)"Transaction should be committed");
            return;
        }
        Assert.assertTrue((boolean)true, (String)"Transaction should be committed");
    }

    @Test(timeOut=30000L)
    public void testCellLevelConflictAnalysisConflict() throws Exception {
        this.tsoClientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.CELL);
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(3735928559L, 3735928558L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)client.getNewStartTimestamp().get();
        long ts2 = (Long)client.getNewStartTimestamp().get();
        client.commit(ts1, testWriteSet1).get();
        try {
            client.commit(ts2, testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AbortException), (String)"Transaction should be aborted");
            return;
        }
        Assert.assertTrue((boolean)false, (String)"Transaction should be aborted");
    }

    @Test(timeOut=30000L)
    public void testCellLevelConflictAnalysisCommit() throws Exception {
        this.tsoClientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.CELL);
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(4276996862L, 3735928559L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)client.getNewStartTimestamp().get();
        long ts2 = (Long)client.getNewStartTimestamp().get();
        client.commit(ts1, testWriteSet1).get();
        try {
            client.commit(ts2, testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertFalse((boolean)(e.getCause() instanceof AbortException), (String)"Transaction should be committed");
            return;
        }
        Assert.assertTrue((boolean)true, (String)"Transaction should be committed");
    }
}

