/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.zk;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtils.class);

    public static CuratorFramework initZKClient(String zkCluster, String namespace, int zkConnectionTimeoutInSec) throws IOException {
        LOG.info("Creating Zookeeper Client connecting to {}", (Object)zkCluster);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework zkClient = CuratorFrameworkFactory.builder().namespace(namespace).connectString(zkCluster).retryPolicy((RetryPolicy)retryPolicy).build();
        zkClient.start();
        try {
            if (!zkClient.blockUntilConnected(zkConnectionTimeoutInSec, TimeUnit.SECONDS)) {
                String errorMsg = String.format("Can't contact ZK cluster '%s' after %d seconds", zkCluster, zkConnectionTimeoutInSec);
                throw new IOException(errorMsg);
            }
            LOG.info("Connected to ZK cluster '{}', client in state: [{}]", (Object)zkCluster, (Object)zkClient.getState());
        }
        catch (InterruptedException ex) {
            throw new IOException(String.format("Interrupted whilst connecting to ZK cluster '%s'", zkCluster));
        }
        return zkClient;
    }
}

