/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.AddExpression;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.util.NumberUtil;

public class DecimalAddExpression
extends AddExpression {
    private Integer maxLength;
    private Integer scale;

    public DecimalAddExpression() {
    }

    public DecimalAddExpression(List<Expression> children) {
        super(children);
        Expression firstChild = children.get(0);
        this.maxLength = this.getPrecision(firstChild);
        this.scale = this.getScale(firstChild);
        for (int i = 1; i < children.size(); ++i) {
            Expression childExpr = children.get(i);
            this.maxLength = DecimalAddExpression.getPrecision(this.maxLength, this.getPrecision(childExpr), this.scale, this.getScale(childExpr));
            this.scale = DecimalAddExpression.getScale(this.maxLength, this.getPrecision(childExpr), this.scale, this.getScale(childExpr));
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal result = null;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression childExpr = (Expression)this.children.get(i);
            if (!childExpr.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType childType = childExpr.getDataType();
            SortOrder childSortOrder = childExpr.getSortOrder();
            BigDecimal bd = (BigDecimal)PDecimal.INSTANCE.toObject(ptr, childType, childSortOrder);
            result = result == null ? bd : result.add(bd);
        }
        if (this.maxLength != null || this.scale != null) {
            result = NumberUtil.setDecimalWidthAndScale(result, this.maxLength, this.scale);
        }
        if (result == null) {
            throw new DataExceedsCapacityException(PDecimal.INSTANCE, this.maxLength, this.scale, null);
        }
        ptr.set(PDecimal.INSTANCE.toBytes(result));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDecimal.INSTANCE;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new DecimalAddExpression(children);
    }
}

