/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.DistinctCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;

class HyperLogLogClientAggregator
extends DistinctCountClientAggregator {
    private HyperLogLogPlus hll = new HyperLogLogPlus(16, 25);

    public HyperLogLogClientAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        try {
            this.hll.addAll(HyperLogLogPlus.Builder.build(ByteUtil.copyKeyBytesIfNecessary(ptr)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        byte[] buffer = new byte[PLong.INSTANCE.getByteSize().intValue()];
        PLong.INSTANCE.getCodec().encodeLong(this.hll.cardinality(), buffer, 0);
        ptr.set(buffer);
        return true;
    }
}

