/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;

@FunctionParseNode.BuiltInFunction(name="OCTET_LENGTH", args={@FunctionParseNode.Argument(allowedTypes={PBinary.class, PVarbinary.class})})
public class OctetLengthFunction
extends ScalarFunction {
    public static final String NAME = "OCTET_LENGTH";

    public OctetLengthFunction() {
    }

    public OctetLengthFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression dataExpr = (Expression)this.children.get(0);
        if (!dataExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        ((PBinaryBase)dataExpr.getDataType()).octetLength(ptr, dataExpr.getSortOrder(), ptr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }
}

