/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.DelegateIndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.hbase.index.write.LeaveIndexActiveFailurePolicy;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexFailurePolicy
extends DelegateIndexFailurePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixIndexFailurePolicy.class);
    public static final String THROW_INDEX_WRITE_FAILURE = "THROW_INDEX_WRITE_FAILURE";
    public static final String DISABLE_INDEX_ON_WRITE_FAILURE = "DISABLE_INDEX_ON_WRITE_FAILURE";
    public static final String REBUILD_INDEX_ON_WRITE_FAILURE = "REBUILD_INDEX_ON_WRITE_FAILURE";
    public static final String BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE = "BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE";
    private RegionCoprocessorEnvironment env;
    private boolean blockDataTableWritesOnFailure;
    private boolean disableIndexOnFailure;
    private boolean rebuildIndexOnFailure;
    private boolean throwIndexWriteFailure;

    public PhoenixIndexFailurePolicy() {
        super(new KillServerOnFailurePolicy());
    }

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        String value;
        super.setup(parent, env);
        this.env = env;
        this.rebuildIndexOnFailure = env.getConfiguration().getBoolean("phoenix.index.failure.handling.rebuild", true);
        HTableDescriptor htd = env.getRegion().getTableDesc();
        if (this.rebuildIndexOnFailure && (value = htd.getValue(REBUILD_INDEX_ON_WRITE_FAILURE)) != null) {
            this.rebuildIndexOnFailure = Boolean.parseBoolean(value);
        }
        this.disableIndexOnFailure = PhoenixIndexFailurePolicy.getDisableIndexOnFailure(env);
        value = htd.getValue(BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE);
        this.blockDataTableWritesOnFailure = value == null ? env.getConfiguration().getBoolean("phoenix.index.failure.block.write", false) : Boolean.parseBoolean(value);
        value = htd.getValue(THROW_INDEX_WRITE_FAILURE);
        this.throwIndexWriteFailure = value == null ? env.getConfiguration().getBoolean("phoenix.index.failure.throw.exception", true) : Boolean.parseBoolean(value);
        boolean killServer = env.getConfiguration().getBoolean("phoenix.index.failure.unhandled.killserver", true);
        if (!killServer) {
            this.setDelegate(new LeaveIndexActiveFailurePolicy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        boolean throwing = true;
        long timestamp = Long.MAX_VALUE;
        Mutation checkMutationForRebuilder = (Mutation)((Map.Entry)attempted.entries().iterator().next()).getValue();
        boolean isIndexRebuild = PhoenixIndexMetaData.isIndexRebuild(checkMutationForRebuilder.getAttributesMap());
        if (isIndexRebuild) {
            SQLException sqlException = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_WRITE_FAILURE).setRootCause(cause).setMessage(cause.getLocalizedMessage()).build().buildException();
            DoNotRetryIOException ioException = ServerUtil.wrapInDoNotRetryIOException("Retrying Index rebuild mutation, we will update Index state to DISABLE if all retries are exhusated", sqlException, timestamp);
            throw ioException;
        }
        try {
            timestamp = this.handleFailureWithExceptions(attempted, cause);
            throwing = false;
        }
        catch (Throwable t) {
            LOGGER.warn("handleFailure failed", t);
            super.handleFailure(attempted, cause);
            throwing = false;
        }
        finally {
            if (!throwing) {
                SQLException sqlException = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_WRITE_FAILURE).setRootCause(cause).setMessage(cause.getLocalizedMessage()).build().buildException();
                DoNotRetryIOException ioException = ServerUtil.wrapInDoNotRetryIOException(null, sqlException, timestamp);
                if (this.throwIndexWriteFailure) {
                    throw ioException;
                }
                LOGGER.warn("Swallowing index write failure", (Throwable)ioException);
            }
        }
    }

    private long handleFailureWithExceptions(Multimap<HTableInterfaceReference, Mutation> attempted, final Exception cause) throws Throwable {
        Set refs = attempted.asMap().keySet();
        final HashMap<String, Long> indexTableNames = new HashMap<String, Long>(refs.size());
        long timestamp = 0L;
        final boolean leaveIndexActive = this.blockDataTableWritesOnFailure || !this.disableIndexOnFailure;
        HashSet<HTableInterfaceReference> failedTables = cause instanceof MultiIndexWriteFailureException ? new HashSet<HTableInterfaceReference>(((MultiIndexWriteFailureException)((Object)cause)).getFailedTables()) : Collections.emptySet();
        for (HTableInterfaceReference ref : refs) {
            if (failedTables.size() > 0 && !failedTables.contains(ref)) continue;
            long minTimeStamp = 0L;
            Collection mutations = attempted.get((Object)ref);
            if (mutations != null) {
                for (Mutation mutation : mutations) {
                    for (List kvs : mutation.getFamilyCellMap().values()) {
                        for (Cell kv : kvs) {
                            if (minTimeStamp != 0L && (kv.getTimestamp() < 0L || minTimeStamp <= kv.getTimestamp())) continue;
                            minTimeStamp = kv.getTimestamp();
                        }
                    }
                }
            }
            timestamp = minTimeStamp;
            if (ref.getTableName().equals(this.env.getRegion().getTableDesc().getNameAsString()) && MetaDataUtil.hasLocalIndexColumnFamily(this.env.getRegion().getTableDesc())) {
                for (String string : this.getLocalIndexNames(ref, mutations)) {
                    indexTableNames.put(string, minTimeStamp);
                }
                if (!(cause instanceof MultiIndexWriteFailureException)) continue;
                ArrayList failedLocalIndexes = Lists.newArrayList((Iterable)Iterables.transform(indexTableNames.entrySet(), (Function)new Function<Map.Entry<String, Long>, HTableInterfaceReference>(){

                    public HTableInterfaceReference apply(Map.Entry<String, Long> input) {
                        return new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)input.getKey())));
                    }
                }));
                ((MultiIndexWriteFailureException)((Object)cause)).setFailedTables(failedLocalIndexes);
                continue;
            }
            indexTableNames.put(ref.getTableName(), minTimeStamp);
        }
        if (!this.disableIndexOnFailure && !this.rebuildIndexOnFailure) {
            return timestamp;
        }
        final PIndexState newState = this.disableIndexOnFailure ? PIndexState.PENDING_DISABLE : PIndexState.PENDING_ACTIVE;
        final long fTimestamp = timestamp;
        return (Long)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws Exception {
                for (Map.Entry tableTimeElement : indexTableNames.entrySet()) {
                    String indexTableName = (String)tableTimeElement.getKey();
                    long minTimeStamp = (Long)tableTimeElement.getValue();
                    if (!PhoenixIndexFailurePolicy.this.disableIndexOnFailure && !PhoenixIndexFailurePolicy.this.blockDataTableWritesOnFailure) {
                        minTimeStamp *= -1L;
                    }
                    try {
                        HTableInterface systemTable = PhoenixIndexFailurePolicy.this.env.getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, PhoenixIndexFailurePolicy.this.env.getConfiguration()));
                        Throwable throwable = null;
                        try {
                            MetaDataProtocol.MetaDataMutationResult result = IndexUtil.updateIndexState(indexTableName, minTimeStamp, systemTable, newState);
                            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                                LOGGER.info("Index " + indexTableName + " has been dropped. Ignore uncommitted mutations");
                                continue;
                            }
                            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                                if (leaveIndexActive) {
                                    LOGGER.warn("Attempt to update INDEX_DISABLE_TIMESTAMP  failed with code = " + (Object)((Object)result.getMutationCode()));
                                    if (PhoenixIndexFailurePolicy.this.blockDataTableWritesOnFailure) {
                                        throw new DoNotRetryIOException("Attempt to update INDEX_DISABLE_TIMESTAMP failed.");
                                    }
                                } else {
                                    LOGGER.warn("Attempt to disable index " + indexTableName + " failed with code = " + (Object)((Object)result.getMutationCode()) + ". Will use default failure policy instead.");
                                    throw new DoNotRetryIOException("Attempt to disable " + indexTableName + " failed.");
                                }
                            }
                            LOGGER.info("Successfully update INDEX_DISABLE_TIMESTAMP for " + indexTableName + " due to an exception while writing updates. indexState=" + (Object)((Object)newState), (Throwable)cause);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (systemTable == null) continue;
                            if (throwable != null) {
                                try {
                                    systemTable.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            systemTable.close();
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new Exception(t);
                    }
                }
                return fTimestamp;
            }
        });
    }

    private Collection<? extends String> getLocalIndexNames(HTableInterfaceReference ref, Collection<Mutation> mutations) throws IOException {
        HashSet<String> indexTableNames = new HashSet<String>(1);
        PhoenixConnection conn = null;
        try {
            conn = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataTable = PhoenixRuntime.getTableNoCache(conn, ref.getTableName());
            List<PTable> indexes = dataTable.getIndexes();
            PTable localIndex = null;
            HashMap<ImmutableBytesWritable, String> localIndexNames = new HashMap<ImmutableBytesWritable, String>();
            for (PTable index : indexes) {
                if (localIndex == null) {
                    localIndex = index;
                }
                localIndexNames.put(new ImmutableBytesWritable(index.getviewIndexIdType().toBytes(index.getViewIndexId())), index.getName().getString());
            }
            if (localIndex == null) {
                Set set = Collections.emptySet();
                return set;
            }
            IndexMaintainer indexMaintainer = localIndex.getIndexMaintainer(dataTable, conn);
            HRegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            int offset = regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length;
            byte[] viewId = null;
            for (Mutation mutation : mutations) {
                viewId = indexMaintainer.getViewIndexIdFromIndexRowKey(new ImmutableBytesWritable(mutation.getRow(), offset, mutation.getRow().length - offset));
                String indexTableName = (String)localIndexNames.get(new ImmutableBytesWritable(viewId));
                if (indexTableName == null) {
                    LOGGER.error("Unable to find local index on " + ref.getTableName() + " with viewID of " + Bytes.toStringBinary((byte[])viewId));
                    continue;
                }
                indexTableNames.add(indexTableName);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
        return indexTableNames;
    }

    public static boolean getDisableIndexOnFailure(RegionCoprocessorEnvironment env) {
        HTableDescriptor htd = env.getRegion().getTableDesc();
        Configuration config = env.getConfiguration();
        String value = htd.getValue(DISABLE_INDEX_ON_WRITE_FAILURE);
        boolean disableIndexOnFailure = value == null ? config.getBoolean("phoenix.index.failure.disable.index", true) : Boolean.parseBoolean(value);
        return disableIndexOnFailure;
    }

    private static void handleIndexWriteFailureFromClient(IndexWriteException indexWriteException, PhoenixConnection conn) {
        PhoenixIndexFailurePolicy.handleExceptionFromClient(indexWriteException, conn, PIndexState.DISABLE);
    }

    private static void handleIndexWriteSuccessFromClient(IndexWriteException indexWriteException, PhoenixConnection conn) {
        PhoenixIndexFailurePolicy.handleExceptionFromClient(indexWriteException, conn, PIndexState.ACTIVE);
    }

    private static void handleExceptionFromClient(IndexWriteException indexWriteException, PhoenixConnection conn, PIndexState indexState) {
        try {
            HashSet<String> indexesToUpdate = new HashSet<String>();
            if (indexWriteException instanceof MultiIndexWriteFailureException) {
                MultiIndexWriteFailureException indexException = (MultiIndexWriteFailureException)indexWriteException;
                List<HTableInterfaceReference> failedIndexes = indexException.getFailedTables();
                if (indexException.isDisableIndexOnFailure() && failedIndexes != null) {
                    for (HTableInterfaceReference failedIndex : failedIndexes) {
                        String failedIndexTable = failedIndex.getTableName();
                        if (indexesToUpdate.contains(failedIndexTable)) continue;
                        PhoenixIndexFailurePolicy.updateIndex(failedIndexTable, conn, indexState);
                        indexesToUpdate.add(failedIndexTable);
                    }
                }
            } else if (indexWriteException instanceof SingleIndexWriteFailureException) {
                SingleIndexWriteFailureException indexException = (SingleIndexWriteFailureException)indexWriteException;
                String failedIndex = indexException.getTableName();
                if (indexException.isDisableIndexOnFailure() && failedIndex != null) {
                    PhoenixIndexFailurePolicy.updateIndex(failedIndex, conn, indexState);
                }
            }
        }
        catch (Exception handleE) {
            LOGGER.warn("Error while trying to handle index write exception", (Throwable)((Object)indexWriteException));
        }
    }

    public static void doBatchWithRetries(MutateCommand mutateCommand, IndexWriteException iwe, PhoenixConnection connection, ReadOnlyProps config) throws IOException {
        if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
            PhoenixIndexFailurePolicy.incrementPendingDisableCounter(iwe, connection);
        }
        int maxTries = config.getInt("hbase.client.retries.number", 31);
        long pause = config.getLong("hbase.client.pause", 100L);
        int numRetry = 1;
        int timeout = 0;
        for (int i = 0; i < maxTries; ++i) {
            timeout = (int)((long)timeout + ConnectionUtils.getPauseTime((long)pause, (int)i));
        }
        long canRetryUntil = EnvironmentEdgeManager.currentTime() + (long)timeout;
        while (PhoenixIndexFailurePolicy.canRetryMore(numRetry++, maxTries, canRetryUntil)) {
            try {
                Thread.sleep(ConnectionUtils.getPauseTime((long)pause, (int)numRetry));
                mutateCommand.doMutation();
                if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
                    PhoenixIndexFailurePolicy.handleIndexWriteSuccessFromClient(iwe, connection);
                }
                return;
            }
            catch (IOException e) {
                SQLException inferredE = ServerUtil.parseLocalOrRemoteServerException(e);
                if (inferredE == null || inferredE.getErrorCode() == SQLExceptionCode.INDEX_WRITE_FAILURE.getErrorCode() || inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) continue;
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
            PhoenixIndexFailurePolicy.handleIndexWriteFailureFromClient(iwe, connection);
        }
        throw new DoNotRetryIOException((Throwable)((Object)iwe));
    }

    private static void incrementPendingDisableCounter(IndexWriteException indexWriteException, PhoenixConnection conn) {
        try {
            HashSet<String> indexesToUpdate = new HashSet<String>();
            if (indexWriteException instanceof MultiIndexWriteFailureException) {
                MultiIndexWriteFailureException indexException = (MultiIndexWriteFailureException)indexWriteException;
                List<HTableInterfaceReference> failedIndexes = indexException.getFailedTables();
                if (indexException.isDisableIndexOnFailure() && failedIndexes != null) {
                    for (HTableInterfaceReference failedIndex : failedIndexes) {
                        String failedIndexTable = failedIndex.getTableName();
                        if (indexesToUpdate.contains(failedIndexTable)) continue;
                        PhoenixIndexFailurePolicy.incrementCounterForIndex(conn, failedIndexTable);
                        indexesToUpdate.add(failedIndexTable);
                    }
                }
            } else if (indexWriteException instanceof SingleIndexWriteFailureException) {
                SingleIndexWriteFailureException indexException = (SingleIndexWriteFailureException)indexWriteException;
                String failedIndex = indexException.getTableName();
                if (indexException.isDisableIndexOnFailure() && failedIndex != null) {
                    PhoenixIndexFailurePolicy.incrementCounterForIndex(conn, failedIndex);
                }
            }
        }
        catch (Exception handleE) {
            LOGGER.warn("Error while trying to handle index write exception", (Throwable)((Object)indexWriteException));
        }
    }

    private static void incrementCounterForIndex(PhoenixConnection conn, String failedIndexTable) throws IOException {
        IndexUtil.incrementCounterForIndex(conn, failedIndexTable, 1L);
    }

    private static void decrementCounterForIndex(PhoenixConnection conn, String failedIndexTable) throws IOException {
        IndexUtil.incrementCounterForIndex(conn, failedIndexTable, -1L);
    }

    private static boolean canRetryMore(int numRetry, int maxRetries, long canRetryUntil) {
        return numRetry < maxRetries || maxRetries > 1 && EnvironmentEdgeManager.currentTime() < canRetryUntil;
    }

    public static IndexWriteException getIndexWriteException(SQLException sqlE) {
        String sqlMsg = sqlE.getMessage();
        if (sqlMsg.contains("Failed to write to multiple index tables: ")) {
            return new MultiIndexWriteFailureException(sqlMsg);
        }
        if (sqlMsg.contains("Failed to make index update:")) {
            return new SingleIndexWriteFailureException(sqlMsg);
        }
        return null;
    }

    private static void updateIndex(String indexFullName, PhoenixConnection conn, PIndexState indexState) throws SQLException, IOException {
        block5: {
            PhoenixIndexFailurePolicy.decrementCounterForIndex(conn, indexFullName);
            Long indexDisableTimestamp = null;
            if (PIndexState.DISABLE.equals((Object)indexState)) {
                LOGGER.info("Disabling index after hitting max number of index write retries: " + indexFullName);
                IndexUtil.updateIndexState(conn, indexFullName, indexState, indexDisableTimestamp);
            } else if (PIndexState.ACTIVE.equals((Object)indexState)) {
                LOGGER.debug("Resetting index to active after subsequent success " + indexFullName);
                indexDisableTimestamp = 0L;
                try {
                    IndexUtil.updateIndexState(conn, indexFullName, indexState, indexDisableTimestamp);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION.getErrorCode()) break block5;
                    throw e;
                }
            }
        }
    }

    public static interface MutateCommand {
        public void doMutation() throws IOException;

        public List<Mutation> getMutationList();
    }
}

