/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.mapreduce.PhoenixMultiViewReader;
import org.apache.phoenix.mapreduce.util.DefaultMultiViewSplitStrategy;
import org.apache.phoenix.mapreduce.util.DefaultPhoenixMultiViewListProvider;
import org.apache.phoenix.mapreduce.util.MultiViewSplitStrategy;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMultiViewListProvider;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixMultiViewInputFormat<T extends Writable>
extends InputFormat<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixMultiViewInputFormat.class);

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        ArrayList listOfInputSplit;
        try {
            Configuration configuration = context.getConfiguration();
            Class defaultMultiInputStrategyClazz = DefaultPhoenixMultiViewListProvider.class;
            if (configuration.get("phoenix.mapreduce.multi.input.strategy.path") != null) {
                defaultMultiInputStrategyClazz = Class.forName(configuration.get("phoenix.mapreduce.multi.input.strategy.path"));
            }
            PhoenixMultiViewListProvider phoenixMultiViewListProvider = (PhoenixMultiViewListProvider)defaultMultiInputStrategyClazz.newInstance();
            List<ViewInfoWritable> views = phoenixMultiViewListProvider.getPhoenixMultiViewList(configuration);
            Class defaultDeletionMultiInputSplitStrategyClazz = DefaultMultiViewSplitStrategy.class;
            if (configuration.get("phoenix.mapreduce.multi.split.strategy.path") != null) {
                defaultDeletionMultiInputSplitStrategyClazz = Class.forName(configuration.get("phoenix.mapreduce.multi.split.strategy.path"));
            }
            MultiViewSplitStrategy multiViewSplitStrategy = (MultiViewSplitStrategy)defaultDeletionMultiInputSplitStrategyClazz.newInstance();
            listOfInputSplit = multiViewSplitStrategy.generateSplits(views, configuration);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("PhoenixMultiViewInputFormat is getting ClassNotFoundException : " + e.getMessage());
            throw new IOException("PhoenixMultiViewInputFormat is getting ClassNotFoundException : " + e.getMessage(), e.getCause());
        }
        catch (InstantiationException e) {
            LOGGER.debug("PhoenixMultiViewInputFormat is getting InstantiationException : " + e.getMessage());
            throw new IOException("PhoenixMultiViewInputFormat is getting InstantiationException : " + e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            LOGGER.debug("PhoenixMultiViewInputFormat is getting IllegalAccessException : " + e.getMessage());
            throw new IOException("PhoenixMultiViewInputFormat is getting IllegalAccessException : " + e.getMessage(), e.getCause());
        }
        return listOfInputSplit == null ? new ArrayList() : listOfInputSplit;
    }

    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) {
        Configuration configuration = context.getConfiguration();
        Class<?> inputClass = PhoenixConfigurationUtil.getInputClass(configuration);
        return this.getPhoenixRecordReader(inputClass, configuration);
    }

    private RecordReader<NullWritable, T> getPhoenixRecordReader(Class<T> inputClass, Configuration configuration) {
        return new PhoenixMultiViewReader<T>(inputClass, configuration);
    }
}

