/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ByteBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpSubstrFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.query.ConnectionQueryServices;

public class RegexpSubstrParseNode
extends FunctionParseNode {
    RegexpSubstrParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public Expression create(List<Expression> children, StatementContext context) throws SQLException {
        ConnectionQueryServices services = context.getConnection().getQueryServices();
        boolean useByteBasedRegex = services.getProps().getBoolean("phoenix.regex.byteBased", false);
        if (useByteBasedRegex) {
            return new ByteBasedRegexpSubstrFunction(children);
        }
        return new StringBasedRegexpSubstrFunction(children);
    }
}

