/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.util.SchemaUtil;

public class GuidePostsCacheWrapper {
    private final GuidePostsCache guidePostsCache;

    GuidePostsCacheWrapper(GuidePostsCache guidePostsCache) {
        this.guidePostsCache = guidePostsCache;
    }

    GuidePostsInfo get(GuidePostsKey key) throws ExecutionException {
        return this.guidePostsCache.get(key);
    }

    void put(GuidePostsKey key, GuidePostsInfo info) {
        this.guidePostsCache.put(key, info);
    }

    void invalidate(GuidePostsKey key) {
        this.guidePostsCache.invalidate(key);
    }

    void invalidateAll() {
        this.guidePostsCache.invalidateAll();
    }

    public void invalidateAll(HTableDescriptor htableDesc) {
        Preconditions.checkNotNull((Object)htableDesc);
        byte[] tableName = htableDesc.getTableName().getName();
        for (byte[] fam : htableDesc.getFamiliesKeys()) {
            this.invalidate(new GuidePostsKey(tableName, fam));
        }
    }

    public void invalidateAll(PTable table) {
        Preconditions.checkNotNull((Object)table);
        byte[] physicalName = table.getPhysicalName().getBytes();
        List<PColumnFamily> families = table.getColumnFamilies();
        if (families.isEmpty()) {
            this.invalidate(new GuidePostsKey(physicalName, SchemaUtil.getEmptyColumnFamily(table)));
        } else {
            for (PColumnFamily family : families) {
                this.invalidate(new GuidePostsKey(physicalName, family.getName().getBytes()));
            }
        }
    }
}

