/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatsLoaderImpl
implements PhoenixStatsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsLoaderImpl.class);
    private final ConnectionQueryServices queryServices;

    public StatsLoaderImpl(ConnectionQueryServices queryServices) {
        this.queryServices = queryServices;
    }

    @Override
    public boolean needsLoad() {
        return true;
    }

    @Override
    public GuidePostsInfo loadStats(GuidePostsKey statsKey) throws Exception {
        return this.loadStats(statsKey, GuidePostsInfo.NO_GUIDEPOST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuidePostsInfo loadStats(GuidePostsKey statsKey, GuidePostsInfo prevGuidepostInfo) throws Exception {
        assert (prevGuidepostInfo != null);
        TableName tableName = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, this.queryServices.getProps());
        HTableInterface statsHTable = this.queryServices.getTable(tableName.getName());
        try {
            GuidePostsInfo guidePostsInfo = StatisticsUtil.readStatistics((Table)statsHTable, statsKey, Long.MAX_VALUE);
            this.traceStatsUpdate(statsKey, guidePostsInfo);
            GuidePostsInfo guidePostsInfo2 = guidePostsInfo;
            return guidePostsInfo2;
        }
        catch (TableNotFoundException e) {
            LOGGER.debug("Unable to locate Phoenix stats table: " + tableName.toString(), (Throwable)e);
            GuidePostsInfo guidePostsInfo = prevGuidepostInfo;
            return guidePostsInfo;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read from stats table: " + tableName.toString(), (Throwable)e);
            GuidePostsInfo guidePostsInfo = prevGuidepostInfo;
            return guidePostsInfo;
        }
        finally {
            try {
                statsHTable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close stats table: " + tableName.toString(), (Throwable)e);
            }
        }
    }

    void traceStatsUpdate(GuidePostsKey key, GuidePostsInfo info) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Updating local TableStats cache (id={}) for {}, size={}bytes", new Object[]{Objects.hashCode(this), key, info.getEstimatedSize()});
        }
    }
}

