/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableRefImpl;
import org.apache.phoenix.schema.SerializedPTableRefFactory;
import org.apache.phoenix.util.ReadOnlyProps;

public class PTableRefFactory {
    private static final PTableRefFactory INSTANCE = new PTableRefFactory();

    public PTableRef makePTableRef(PTable table, long lastAccessTime, long resolvedTime) {
        return new PTableRefImpl(table, lastAccessTime, resolvedTime, table.getEstimatedSize());
    }

    public PTableRef makePTableRef(PTableRef tableRef) {
        return new PTableRefImpl(tableRef);
    }

    public static PTableRefFactory getFactory(ReadOnlyProps props) {
        String encodingEnumString = props.get("phoenix.table.client.cache.encoding", QueryServicesOptions.DEFAULT_CLIENT_CACHE_ENCODING);
        Encoding encoding = Encoding.valueOf(encodingEnumString.toUpperCase());
        switch (encoding) {
            case PROTOBUF: {
                return SerializedPTableRefFactory.getFactory();
            }
        }
        return INSTANCE;
    }

    public static enum Encoding {
        OBJECT,
        PROTOBUF;

    }
}

