/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.util.ByteUtil;

public class PrefixByteEncoder {
    private int maxLength;
    private final ImmutableBytesWritable previous = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);

    public void reset() {
        this.previous.set(ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void encode(DataOutput out, ImmutableBytesWritable ptr) throws IOException {
        this.encode(out, ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public void encode(DataOutput out, byte[] b) throws IOException {
        this.encode(out, b, 0, b.length);
    }

    public void encode(DataOutput out, byte[] b, int offset, int length) throws IOException {
        int i = 0;
        int prevOffset = this.previous.getOffset();
        byte[] prevBytes = this.previous.get();
        int prevLength = this.previous.getLength();
        int minLength = prevLength < b.length ? prevLength : b.length;
        for (i = 0; i < minLength && prevBytes[prevOffset + i] == b[offset + i]; ++i) {
        }
        WritableUtils.writeVInt((DataOutput)out, (int)i);
        Bytes.writeByteArray((DataOutput)out, (byte[])b, (int)(offset + i), (int)(length - i));
        this.previous.set(b, offset, length);
        if (length > this.maxLength) {
            this.maxLength = length;
        }
    }
}

