/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.TxConstants;
import org.apache.tephra.persist.TransactionSnapshot;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.snapshot.BinaryDecoder;
import org.apache.tephra.snapshot.BinaryEncoder;
import org.apache.tephra.snapshot.SnapshotCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCodecProvider
implements SnapshotCodec {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotCodecProvider.class);
    private final SortedMap<Integer, SnapshotCodec> codecs = Maps.newTreeMap();

    @Inject
    public SnapshotCodecProvider(Configuration configuration) {
        this.initialize(configuration);
    }

    private void initialize(Configuration configuration) {
        String[] codecClassNames = configuration.getTrimmedStrings("data.tx.snapshot.codecs");
        ArrayList codecClasses = Lists.newArrayList();
        if (codecClassNames != null) {
            for (String clsName : codecClassNames) {
                try {
                    codecClasses.add(Class.forName(clsName));
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.warn("Unable to load class configured for data.tx.snapshot.codecs: " + (String)clsName, (Throwable)cnfe);
                }
            }
        }
        if (codecClasses.size() == 0) {
            codecClasses.addAll(Arrays.asList(TxConstants.Persist.DEFAULT_TX_SNAPHOT_CODEC_CLASSES));
        }
        for (Class codecClass : codecClasses) {
            try {
                SnapshotCodec codec = (SnapshotCodec)codecClass.newInstance();
                this.codecs.put(codec.getVersion(), codec);
                LOG.debug("Using snapshot codec {} for snapshots of version {}", (Object)codecClass.getName(), (Object)codec.getVersion());
            }
            catch (Exception e) {
                LOG.warn("Error instantiating snapshot codec {}. Skipping.", (Object)codecClass.getName(), (Object)e);
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    SnapshotCodec getCodecForVersion(int version) {
        SnapshotCodec codec = (SnapshotCodec)this.codecs.get(version);
        if (codec == null) {
            throw new IllegalArgumentException(String.format("Version %d of snapshot encoding is not supported", version));
        }
        return codec;
    }

    private SnapshotCodec getCurrentCodec() {
        if (this.codecs.isEmpty()) {
            throw new IllegalStateException(String.format("No codecs are registered.", new Object[0]));
        }
        return (SnapshotCodec)this.codecs.get(this.codecs.lastKey());
    }

    private SnapshotCodec getCodec(InputStream in) {
        int persistedVersion;
        BinaryDecoder decoder = new BinaryDecoder(in);
        try {
            persistedVersion = decoder.readInt();
        }
        catch (IOException e) {
            LOG.error("Unable to read transaction state version: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        return this.getCodecForVersion(persistedVersion);
    }

    @Override
    public int getVersion() {
        return this.getCurrentCodec().getVersion();
    }

    @Override
    public TransactionSnapshot decode(InputStream in) {
        return this.getCodec(in).decode(in);
    }

    @Override
    public TransactionVisibilityState decodeTransactionVisibilityState(InputStream in) {
        return this.getCodec(in).decodeTransactionVisibilityState(in);
    }

    @Override
    public void encode(OutputStream out, TransactionSnapshot snapshot) {
        SnapshotCodec codec = this.getCurrentCodec();
        try {
            new BinaryEncoder(out).writeInt(codec.getVersion());
        }
        catch (IOException e) {
            LOG.error("Unable to write transaction state version: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        codec.encode(out, snapshot);
    }
}

