/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.internal.DefaultRuntimeSpecification;

final class RuntimeSpecificationCodec
implements JsonSerializer<RuntimeSpecification>,
JsonDeserializer<RuntimeSpecification> {
    RuntimeSpecificationCodec() {
    }

    @Override
    public JsonElement serialize(RuntimeSpecification src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("name", src.getName());
        json.add("runnable", context.serialize(src.getRunnableSpecification(), (Type)((Object)TwillRunnableSpecification.class)));
        json.add("resources", context.serialize(src.getResourceSpecification(), (Type)((Object)ResourceSpecification.class)));
        json.add("files", context.serialize(src.getLocalFiles(), new TypeToken<Collection<LocalFile>>(){}.getType()));
        return json;
    }

    @Override
    public RuntimeSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String name = jsonObj.get("name").getAsString();
        TwillRunnableSpecification runnable = (TwillRunnableSpecification)context.deserialize(jsonObj.get("runnable"), (Type)((Object)TwillRunnableSpecification.class));
        ResourceSpecification resources = (ResourceSpecification)context.deserialize(jsonObj.get("resources"), (Type)((Object)ResourceSpecification.class));
        Collection files = (Collection)context.deserialize(jsonObj.get("files"), new TypeToken<Collection<LocalFile>>(){}.getType());
        return new DefaultRuntimeSpecification(name, runnable, resources, files);
    }
}

