/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.AttributedStyles;
import sqlline.OutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

class TableOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;

    TableOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    @Override
    public int print(Rows rows) {
        int index = 0;
        AttributedString header = null;
        AttributedString headerCols = null;
        int width = this.getCalculatedWidth();
        rows.normalizeWidths(this.sqlLine.getOpts().getMaxColumnWidth());
        while (rows.hasNext()) {
            Rows.Row row = (Rows.Row)rows.next();
            AttributedString attributedString = this.getOutputString(rows, row);
            attributedString = attributedString.substring(0, Math.min(attributedString.length(), width));
            if (index == 0) {
                StringBuilder h = new StringBuilder();
                for (int j = 0; j < row.sizes.length; ++j) {
                    for (int k = 0; k < row.sizes[j]; ++k) {
                        h.append('-');
                    }
                    h.append("-+-");
                }
                headerCols = attributedString;
                header = new AttributedStringBuilder().append(h.toString(), AttributedStyles.GREEN).toAttributedString().subSequence(0, Math.min(h.length(), headerCols.length()));
            }
            if (this.sqlLine.getOpts().getShowHeader()) {
                int headerInterval = this.sqlLine.getOpts().getHeaderInterval();
                if (index == 0 || headerInterval > 0 && index % headerInterval == 0) {
                    this.printRow(header, true);
                    this.printRow(headerCols, false);
                    this.printRow(header, true);
                }
            }
            if (index != 0) {
                this.printRow(attributedString, false);
            }
            ++index;
        }
        if (header != null && this.sqlLine.getOpts().getShowHeader()) {
            this.printRow(header, true);
        }
        return index - 1;
    }

    private int getCalculatedWidth() {
        int maxWidth = this.sqlLine.getOpts().getMaxWidth();
        int width = (maxWidth == 0 && this.sqlLine.getLineReader() != null ? this.sqlLine.getLineReader().getTerminal().getWidth() : maxWidth) - 4;
        return Math.max(width, 0);
    }

    void printRow(AttributedString attributedString, boolean header) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        if (header) {
            this.sqlLine.output(builder.append("+-", AttributedStyles.GREEN).append(attributedString).append("-+", AttributedStyles.GREEN).toAttributedString());
        } else {
            this.sqlLine.output(builder.append("| ", AttributedStyles.GREEN).append(attributedString).append(" |", AttributedStyles.GREEN).toAttributedString());
        }
    }

    public AttributedString getOutputString(Rows rows, Rows.Row row) {
        return this.getOutputString(rows, row, " | ");
    }

    private AttributedString getOutputString(Rows rows, Rows.Row row, String delim) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        boolean isStyled = this.sqlLine.getOpts().getColor();
        for (int i = 0; i < row.values.length; ++i) {
            String v;
            if (builder.length() > 0) {
                builder.append(delim, isStyled ? AttributedStyles.GREEN : AttributedStyle.DEFAULT);
            }
            int[] sizes = row.sizes;
            if (row.isMeta) {
                v = SqlLine.center(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    builder.append(v, AttributedStyles.CYAN);
                    continue;
                }
                builder.append(v, AttributedStyle.BOLD);
                continue;
            }
            v = SqlLine.rpad(row.values[i], row.sizes[i]);
            if (rows.isPrimaryKey(i)) {
                builder.append(v, AttributedStyles.CYAN);
                continue;
            }
            builder.append(v);
        }
        if (row.deleted) {
            return new AttributedStringBuilder().append(builder.toString(), AttributedStyles.RED).toAttributedString();
        }
        if (row.updated) {
            return new AttributedStringBuilder().append(builder.toString(), AttributedStyles.BLUE).toAttributedString();
        }
        if (row.inserted) {
            return new AttributedStringBuilder().append(builder.toString(), AttributedStyles.GREEN).toAttributedString();
        }
        return builder.toAttributedString();
    }
}

