/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Ddl;
import org.apache.phoenix.pherf.configuration.IdleTime;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.configuration.Upsert;
import org.apache.phoenix.pherf.configuration.UserDefined;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.IdleTimeOperation;
import org.apache.phoenix.pherf.workload.mt.operations.IdleTimeOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.PreScenarioOperation;
import org.apache.phoenix.pherf.workload.mt.operations.PreScenarioOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.QueryOperation;
import org.apache.phoenix.pherf.workload.mt.operations.QueryOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.UpsertOperation;
import org.apache.phoenix.pherf.workload.mt.operations.UpsertOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.UserDefinedOperation;
import org.apache.phoenix.pherf.workload.mt.operations.UserDefinedOperationSupplier;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Supplier;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.hash.BloomFilter;
import org.apache.phoenix.thirdparty.com.google.common.hash.Funnel;
import org.apache.phoenix.thirdparty.com.google.common.hash.PrimitiveSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantOperationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantOperationFactory.class);
    private final PhoenixUtil phoenixUtil;
    private final DataModel model;
    private final Scenario scenario;
    private final XMLConfigParser parser;
    private final RulesApplier rulesApplier;
    private final LoadProfile loadProfile;
    private final List<Operation> operationList = Lists.newArrayList();
    private final Map<Operation.OperationType, Supplier<Function<TenantOperationInfo, OperationStats>>> operationSuppliers = Maps.newEnumMap(Operation.OperationType.class);
    private final BloomFilter<TenantView> tenantsLoaded;
    private final ReentrantReadWriteLock viewCreationLock = new ReentrantReadWriteLock();

    public TenantOperationFactory(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario) {
        List<Operation> udfOperations;
        List<Operation> idleOperations;
        List<Operation> queryOperations;
        List<Operation> upsertOperations;
        this.phoenixUtil = phoenixUtil;
        this.model = model;
        this.scenario = scenario;
        this.parser = null;
        this.rulesApplier = new RulesApplier(model);
        this.loadProfile = this.scenario.getLoadProfile();
        this.tenantsLoaded = this.createTenantsLoadedFilter(this.loadProfile);
        if (scenario.getPreScenarioDdls() != null && scenario.getPreScenarioDdls().size() > 0) {
            this.operationSuppliers.put(Operation.OperationType.PRE_RUN, new PreScenarioOperationSupplier(phoenixUtil, model, scenario));
        }
        if ((upsertOperations = this.getUpsertOperationsForScenario(scenario)).size() > 0) {
            this.operationList.addAll(upsertOperations);
            this.operationSuppliers.put(Operation.OperationType.UPSERT, new UpsertOperationSupplier(phoenixUtil, model, scenario));
        }
        if ((queryOperations = this.getQueryOperationsForScenario(scenario)).size() > 0) {
            this.operationList.addAll(queryOperations);
            this.operationSuppliers.put(Operation.OperationType.SELECT, new QueryOperationSupplier(phoenixUtil, model, scenario));
        }
        if ((idleOperations = this.getIdleTimeOperationsForScenario(scenario)).size() > 0) {
            this.operationList.addAll(idleOperations);
            this.operationSuppliers.put(Operation.OperationType.IDLE_TIME, new IdleTimeOperationSupplier(phoenixUtil, model, scenario));
        }
        if ((udfOperations = this.getUDFOperationsForScenario(scenario)).size() > 0) {
            this.operationList.addAll(udfOperations);
            this.operationSuppliers.put(Operation.OperationType.USER_DEFINED, new UserDefinedOperationSupplier(phoenixUtil, model, scenario));
        }
    }

    private BloomFilter createTenantsLoadedFilter(LoadProfile loadProfile) {
        Funnel<TenantView> tenantViewFunnel = new Funnel<TenantView>(){

            @Override
            public void funnel(TenantView tenantView, PrimitiveSink into) {
                into.putString(tenantView.getTenantId(), Charsets.UTF_8).putString(tenantView.getViewName(), Charsets.UTF_8);
            }
        };
        int numTenants = 0;
        for (TenantGroup tg : loadProfile.getTenantDistribution()) {
            numTenants += tg.getNumTenants();
        }
        return BloomFilter.create(tenantViewFunnel, numTenants, 1.0E-7);
    }

    private List<Operation> getUpsertOperationsForScenario(Scenario scenario) {
        ArrayList<Operation> opList = Lists.newArrayList();
        for (final Upsert upsert : scenario.getUpserts()) {
            UpsertOperation upsertOp = new UpsertOperation(){

                @Override
                public Upsert getUpsert() {
                    return upsert;
                }

                @Override
                public String getId() {
                    return upsert.getId();
                }

                @Override
                public Operation.OperationType getType() {
                    return Operation.OperationType.UPSERT;
                }
            };
            opList.add(upsertOp);
        }
        return opList;
    }

    private List<Operation> getQueryOperationsForScenario(Scenario scenario) {
        ArrayList<Operation> opList = Lists.newArrayList();
        for (QuerySet querySet : scenario.getQuerySet()) {
            for (final Query query : querySet.getQuery()) {
                QueryOperation queryOp = new QueryOperation(){

                    @Override
                    public Query getQuery() {
                        return query;
                    }

                    @Override
                    public String getId() {
                        return query.getId();
                    }

                    @Override
                    public Operation.OperationType getType() {
                        return Operation.OperationType.SELECT;
                    }
                };
                opList.add(queryOp);
            }
        }
        return opList;
    }

    private List<Operation> getIdleTimeOperationsForScenario(Scenario scenario) {
        ArrayList<Operation> opList = Lists.newArrayList();
        for (final IdleTime idleTime : scenario.getIdleTimes()) {
            IdleTimeOperation idleTimeOperation = new IdleTimeOperation(){

                @Override
                public IdleTime getIdleTime() {
                    return idleTime;
                }

                @Override
                public String getId() {
                    return idleTime.getId();
                }

                @Override
                public Operation.OperationType getType() {
                    return Operation.OperationType.IDLE_TIME;
                }
            };
            opList.add(idleTimeOperation);
        }
        return opList;
    }

    private List<Operation> getUDFOperationsForScenario(Scenario scenario) {
        ArrayList<Operation> opList = Lists.newArrayList();
        for (final UserDefined udf : scenario.getUdfs()) {
            UserDefinedOperation udfOperation = new UserDefinedOperation(){

                @Override
                public UserDefined getUserFunction() {
                    return udf;
                }

                @Override
                public String getId() {
                    return udf.getId();
                }

                @Override
                public Operation.OperationType getType() {
                    return Operation.OperationType.USER_DEFINED;
                }
            };
            opList.add(udfOperation);
        }
        return opList;
    }

    public PhoenixUtil getPhoenixUtil() {
        return this.phoenixUtil;
    }

    public DataModel getModel() {
        return this.model;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public List<Operation> getOperations() {
        return this.operationList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTenant(TenantOperationInfo input) throws Exception {
        TenantView tenantView = new TenantView(input.getTenantId(), this.scenario.getTableName());
        this.viewCreationLock.writeLock().lock();
        try {
            if (!this.tenantsLoaded.mightContain(tenantView)) {
                this.executePreRunOpsForTenant(tenantView, input);
                boolean updated = this.tenantsLoaded.put(tenantView);
                if (updated) {
                    LOGGER.info(String.format("Successfully initialized tenant. [%s, %s] ", tenantView.tenantId, tenantView.viewName));
                }
            }
        }
        finally {
            this.viewCreationLock.writeLock().unlock();
        }
    }

    public Supplier<Function<TenantOperationInfo, OperationStats>> getOperationSupplier(TenantOperationInfo input) throws Exception {
        Supplier<Function<TenantOperationInfo, OperationStats>> opSupplier = this.operationSuppliers.get((Object)input.getOperation().getType());
        if (opSupplier == null) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        return opSupplier;
    }

    private void executePreRunOpsForTenant(TenantView tenantView, TenantOperationInfo input) throws Exception {
        Supplier<Function<TenantOperationInfo, OperationStats>> preRunOpSupplier = this.operationSuppliers.get((Object)Operation.OperationType.PRE_RUN);
        if (preRunOpSupplier != null) {
            PreScenarioOperation operation = new PreScenarioOperation(){

                @Override
                public List<Ddl> getPreScenarioDdls() {
                    List<Ddl> ddls = TenantOperationFactory.this.scenario.getPreScenarioDdls();
                    return ddls == null ? Lists.newArrayList() : ddls;
                }

                @Override
                public String getId() {
                    return Operation.OperationType.PRE_RUN.name();
                }

                @Override
                public Operation.OperationType getType() {
                    return Operation.OperationType.PRE_RUN;
                }
            };
            TenantOperationInfo preRunSample = new TenantOperationInfo(input.getModelName(), input.getScenarioName(), input.getTableName(), input.getTenantGroupId(), Operation.OperationType.PRE_RUN.name(), input.getTenantId(), operation);
            try {
                OperationStats stats = preRunOpSupplier.get().apply(preRunSample);
                TenantOperationFactory tenantOperationFactory = this;
                LOGGER.info(tenantOperationFactory.phoenixUtil.getGSON().toJson(stats));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to initialize tenant. [%s, %s] ", tenantView.tenantId, tenantView.viewName), (Throwable)e);
                if (e.getClass().isAssignableFrom(SQLException.class)) {
                    SQLException sqlException = (SQLException)e;
                    if (SQLExceptionCode.CONCURRENT_TABLE_MUTATION.getErrorCode() != sqlException.getErrorCode()) {
                        throw e;
                    }
                }
                throw e;
            }
        }
    }

    private static class TenantView {
        private final String tenantId;
        private final String viewName;

        public TenantView(String tenantId, String viewName) {
            this.tenantId = tenantId;
            this.viewName = viewName;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getViewName() {
            return this.viewName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TenantView that = (TenantView)o;
            return this.getTenantId().equals(that.getTenantId()) && this.getViewName().equals(that.getViewName());
        }

        public int hashCode() {
            return Objects.hash(this.getTenantId(), this.getViewName());
        }
    }
}

