/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import java.io.PrintStream;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class MRPrinter
extends MROpPlanVisitor {
    private PrintStream mStream = null;
    private boolean isVerbose = true;

    public MRPrinter(PrintStream ps, MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DependencyOrderWalker<MapReduceOper, MROperPlan>(plan, true));
        this.mStream = ps;
        this.mStream.println("#--------------------------------------------------");
        this.mStream.println("# Map Reduce Plan                                  ");
        this.mStream.println("#--------------------------------------------------");
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        PlanPrinter printer;
        this.mStream.println("MapReduce node " + mr.getOperatorKey().toString());
        if (mr instanceof NativeMapReduceOper) {
            this.mStream.println(((NativeMapReduceOper)mr).getCommandString());
            this.mStream.println("--------");
            this.mStream.println();
            return;
        }
        if (mr.mapPlan != null && mr.mapPlan.size() > 0) {
            this.mStream.println("Map Plan");
            printer = new PlanPrinter(mr.mapPlan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println("--------");
        }
        if (mr.combinePlan != null && mr.combinePlan.size() > 0) {
            this.mStream.println("Combine Plan");
            printer = new PlanPrinter(mr.combinePlan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println("--------");
        }
        if (mr.reducePlan != null && mr.reducePlan.size() > 0) {
            this.mStream.println("Reduce Plan");
            printer = new PlanPrinter(mr.reducePlan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println("--------");
        }
        this.mStream.println("Global sort: " + mr.isGlobalSort());
        if (mr.getQuantFile() != null) {
            this.mStream.println("Quantile file: " + mr.getQuantFile());
        }
        if (mr.getUseSecondaryKey()) {
            this.mStream.println("Secondary sort: " + mr.getUseSecondaryKey());
        }
        this.mStream.println("----------------");
        this.mStream.println("");
    }
}

