/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.pig.PigException;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.tools.parameters.TokenMgrError;
import org.apache.pig.tools.pigscript.parser.ParseException;

public class LogUtils {
    public static void warn(Object o, String msg, PigWarning warningEnum, Log log) {
        PigLogger pigLogger = PhysicalOperator.getPigLogger();
        if (pigLogger != null) {
            pigLogger.warn(o, msg, warningEnum);
        } else {
            log.warn((Object)msg);
        }
    }

    public static Exception getPermissionException(Exception top) {
        Throwable current;
        for (current = top; current != null && (current.getMessage() == null || current.getMessage().indexOf("Permission denied") == -1); current = current.getCause()) {
        }
        return current;
    }

    public static PigException getPigException(Throwable top) {
        Throwable current = top;
        Throwable pigException = top;
        if (current instanceof PigException && ((PigException)current).getErrorCode() != 0 && ((PigException)current).getMarkedAsShowToUser()) {
            return (PigException)current;
        }
        while (!(current == null || current.getCause() == null || (current = current.getCause()) instanceof PigException && ((PigException)current).getErrorCode() != 0 && ((PigException)(pigException = current)).getMarkedAsShowToUser())) {
        }
        return pigException instanceof PigException ? (PigException)pigException : null;
    }

    public static void writeLog(Throwable t, String logFileName, Log log, boolean verbose, String headerMessage) {
        LogUtils.writeLog(t, logFileName, log, verbose, headerMessage, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(Throwable t, String logFileName, Log log, boolean verbose, String headerMessage, boolean displayFooter, boolean displayMessage) {
        PigException pigException;
        Exception pe;
        String message = null;
        String marker = null;
        StringBuilder sb = new StringBuilder("=");
        for (int i = 0; i < 79; ++i) {
            sb.append("=");
        }
        sb.append("\n");
        marker = sb.toString();
        if (t instanceof Exception && (pe = LogUtils.getPermissionException((Exception)t)) != null) {
            log.error((Object)("You don't have permission to perform the operation. Error from the server: " + pe.getMessage()));
        }
        message = (pigException = LogUtils.getPigException(t)) != null ? "ERROR " + pigException.getErrorCode() + ": " + pigException.getMessage() : (t instanceof ParseException || t instanceof org.apache.pig.tools.pigscript.parser.TokenMgrError || t instanceof TokenMgrError ? "ERROR 1000: Error during parsing. " + t.getMessage() : (t instanceof IOException ? "ERROR 2997: Encountered IOException. " + t.getMessage() : (t instanceof RuntimeException ? "ERROR 2999: Unexpected internal error. " + t.getMessage() : "ERROR 2998: Unhandled internal error. " + t.getMessage())));
        FileOutputStream fos = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bs));
        if (displayMessage) {
            log.error((Object)message);
        }
        if (verbose) {
            log.error((Object)bs.toString());
        }
        if (logFileName == null || logFileName.equals("")) {
            log.warn((Object)"There is no log file to write to.");
            log.error((Object)bs.toString());
            return;
        }
        File logFile = new File(logFileName);
        try {
            fos = new FileOutputStream(logFile, true);
            if (headerMessage != null) {
                fos.write((headerMessage + "\n").getBytes("UTF-8"));
                sb = new StringBuilder("-");
                for (int i = 1; i < headerMessage.length(); ++i) {
                    sb.append("-");
                }
                sb.append("\n");
                fos.write(sb.toString().getBytes("UTF-8"));
            }
            if (message != null) {
                if (message.charAt(message.length() - 1) == '\n') {
                    fos.write((message + "\n").getBytes("UTF-8"));
                } else {
                    fos.write((message + "\n\n").getBytes("UTF-8"));
                }
            }
            fos.write(bs.toString().getBytes("UTF-8"));
            fos.write(marker.getBytes("UTF-8"));
            if (displayFooter) {
                if (verbose) {
                    System.err.println("Details also at logfile: " + logFileName);
                } else {
                    System.err.println("Details at logfile: " + logFileName);
                }
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("Could not write to log file: " + logFileName + " :" + ioe.getMessage()));
            log.error((Object)bs.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(String headerMessage, String message, String logFileName, Log log) {
        if (logFileName == null || logFileName.equals("")) {
            log.warn((Object)"There is no log file to write to.");
            log.error((Object)(headerMessage + "\n" + message));
            return;
        }
        File logFile = new File(logFileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(logFile, true);
            if (headerMessage != null) {
                fos.write((headerMessage + "\n").getBytes("UTF-8"));
                StringBuilder sb = new StringBuilder("-");
                for (int i = 1; i < headerMessage.length(); ++i) {
                    sb.append("-");
                }
                sb.append("\n");
                fos.write(sb.toString().getBytes("UTF-8"));
            }
            if (message != null) {
                if (message.charAt(message.length() - 1) == '\n') {
                    fos.write((message + "\n").getBytes("UTF-8"));
                } else {
                    fos.write((message + "\n\n").getBytes("UTF-8"));
                }
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("Could not write to log file: " + logFileName + " :" + ioe.getMessage()));
            log.error((Object)message);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }
}

