/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.gc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.KeeperException;

public class GarbageCollectWriteAheadLogs {
    private static final Logger log = Logger.getLogger(GarbageCollectWriteAheadLogs.class);
    private final Instance instance;
    private final FileSystem fs;
    private Trash trash;

    GarbageCollectWriteAheadLogs(Instance instance, FileSystem fs, boolean noTrash) throws IOException {
        this.instance = instance;
        this.fs = fs;
        if (!noTrash) {
            this.trash = new Trash(fs, fs.getConf());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(GCStatus status) {
        Span span = Trace.start((String)"scanServers");
        try {
            Set<String> sortedWALogs = this.getSortedWALogs();
            status.currentLog.started = System.currentTimeMillis();
            HashMap<String, String> fileToServerMap = new HashMap<String, String>();
            int count = this.scanServers(fileToServerMap);
            long fileScanStop = System.currentTimeMillis();
            log.info((Object)String.format("Fetched %d files from %d servers in %.2f seconds", fileToServerMap.size(), count, (double)(fileScanStop - status.currentLog.started) / 1000.0));
            status.currentLog.candidates = fileToServerMap.size();
            span.stop();
            span = Trace.start((String)"removeMetadataEntries");
            try {
                count = GarbageCollectWriteAheadLogs.removeMetadataEntries(fileToServerMap, sortedWALogs, status);
            }
            catch (Exception ex) {
                log.error((Object)"Unable to scan metadata table", (Throwable)ex);
                return;
            }
            finally {
                span.stop();
            }
            long logEntryScanStop = System.currentTimeMillis();
            log.info((Object)String.format("%d log entries scanned in %.2f seconds", count, (double)(logEntryScanStop - fileScanStop) / 1000.0));
            span = Trace.start((String)"removeFiles");
            Map<String, ArrayList<String>> serverToFileMap = GarbageCollectWriteAheadLogs.mapServersToFiles(fileToServerMap);
            count = this.removeFiles(serverToFileMap, sortedWALogs, status);
            long removeStop = System.currentTimeMillis();
            log.info((Object)String.format("%d total logs removed from %d servers in %.2f seconds", count, serverToFileMap.size(), (double)(removeStop - logEntryScanStop) / 1000.0));
            status.currentLog.finished = removeStop;
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
            span.stop();
        }
        catch (Exception e) {
            log.error((Object)"exception occured while garbage collecting write ahead logs", (Throwable)e);
            span.stop();
        }
    }

    boolean holdsLock(InetSocketAddress addr) {
        try {
            String zpath = ZooUtil.getRoot((Instance)this.instance) + "/tservers" + "/" + AddressUtil.toString((InetSocketAddress)addr);
            List children = ZooReaderWriter.getInstance().getChildren(zpath);
            return children != null && !children.isEmpty();
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (Exception ex) {
            log.debug((Object)ex, (Throwable)ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFiles(Map<String, ArrayList<String>> serverToFileMap, Set<String> sortedWALogs, GCStatus status) {
        AccumuloConfiguration conf = this.instance.getConfiguration();
        for (Map.Entry<String, ArrayList<String>> entry : serverToFileMap.entrySet()) {
            if (entry.getKey().length() == 0) {
                for (String filename : entry.getValue()) {
                    log.debug((Object)("Removing old-style WAL " + entry.getValue()));
                    try {
                        Path path = new Path(Constants.getWalDirectory((AccumuloConfiguration)conf), filename);
                        if (this.trash == null || !this.trash.moveToTrash(path)) {
                            this.fs.delete(path, true);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        log.error((Object)("Unable to delete wal " + filename + ": " + ex));
                    }
                }
                continue;
            }
            InetSocketAddress address = org.apache.accumulo.server.util.AddressUtil.parseAddress(entry.getKey(), Property.TSERV_CLIENTPORT);
            if (!this.holdsLock(address)) {
                Path serverPath = new Path(Constants.getWalDirectory((AccumuloConfiguration)conf), entry.getKey());
                for (String filename : entry.getValue()) {
                    log.debug((Object)("Removing WAL for offline server " + filename));
                    try {
                        Path path = new Path(serverPath, filename);
                        if (this.trash == null || !this.trash.moveToTrash(path)) {
                            this.fs.delete(path, true);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        log.error((Object)("Unable to delete wal " + filename + ": " + ex));
                    }
                }
                continue;
            }
            TabletClientService.Client tserver = null;
            try {
                tserver = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)address, (AccumuloConfiguration)conf);
                tserver.removeLogs(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), (List)entry.getValue());
                log.debug((Object)("deleted " + entry.getValue() + " from " + entry.getKey()));
                status.currentLog.deleted += (long)entry.getValue().size();
                if (tserver == null) continue;
            }
            catch (TException e) {
                try {
                    log.warn((Object)("Error talking to " + address + ": " + (Object)((Object)e)));
                    if (tserver == null) continue;
                }
                catch (Throwable throwable) {
                    if (tserver != null) {
                        ThriftUtil.returnClient(tserver);
                    }
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver);
        }
        Path recoveryDir = new Path(Constants.getRecoveryDir((AccumuloConfiguration)conf));
        for (String sortedWALog : sortedWALogs) {
            log.debug((Object)("Removing sorted WAL " + sortedWALog));
            Path swalog = new Path(recoveryDir, sortedWALog);
            try {
                if (this.trash != null && this.trash.moveToTrash(swalog)) continue;
                this.fs.delete(swalog, true);
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                try {
                    if (!this.fs.exists(swalog)) continue;
                    log.error((Object)("Unable to delete sorted walog " + sortedWALog + ": " + ioe));
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to check for the existence of " + sortedWALog), (Throwable)ex);
                }
            }
        }
        return 0;
    }

    private static Map<String, ArrayList<String>> mapServersToFiles(Map<String, String> fileToServerMap) {
        HashMap<String, ArrayList<String>> serverToFileMap = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, String> fileServer : fileToServerMap.entrySet()) {
            ArrayList<String> files = (ArrayList<String>)serverToFileMap.get(fileServer.getValue());
            if (files == null) {
                files = new ArrayList<String>();
                serverToFileMap.put(fileServer.getValue(), files);
            }
            files.add(fileServer.getKey());
        }
        return serverToFileMap;
    }

    private static int removeMetadataEntries(Map<String, String> fileToServerMap, Set<String> sortedWALogs, GCStatus status) throws IOException, KeeperException, InterruptedException {
        int count = 0;
        Iterator<MetadataTable.LogEntry> iterator = MetadataTable.getLogEntries(SecurityConstants.getSystemCredentials());
        while (iterator.hasNext()) {
            for (String filename : iterator.next().logSet) {
                if (fileToServerMap.remove(filename = filename.split("/", 2)[1]) != null) {
                    ++status.currentLog.inUse;
                }
                sortedWALogs.remove(filename);
                ++count;
            }
        }
        return count;
    }

    private int scanServers(Map<String, String> fileToServerMap) throws Exception {
        AccumuloConfiguration conf = this.instance.getConfiguration();
        Path walRoot = new Path(Constants.getWalDirectory((AccumuloConfiguration)conf));
        for (FileStatus status : this.fs.listStatus(walRoot)) {
            String name = status.getPath().getName();
            if (status.isDir()) {
                for (FileStatus file : this.fs.listStatus(new Path(walRoot, name))) {
                    if (GarbageCollectWriteAheadLogs.isUUID(file.getPath().getName())) {
                        fileToServerMap.put(file.getPath().getName(), name);
                        continue;
                    }
                    log.info((Object)("Ignoring file " + file.getPath() + " because it doesn't look like a uuid"));
                }
                continue;
            }
            if (GarbageCollectWriteAheadLogs.isUUID(name)) {
                fileToServerMap.put(name, "");
                continue;
            }
            log.info((Object)("Ignoring file " + name + " because it doesn't look like a uuid"));
        }
        int count = 0;
        return count;
    }

    private Set<String> getSortedWALogs() throws IOException {
        AccumuloConfiguration conf = this.instance.getConfiguration();
        Path recoveryDir = new Path(Constants.getRecoveryDir((AccumuloConfiguration)conf));
        HashSet<String> sortedWALogs = new HashSet<String>();
        if (this.fs.exists(recoveryDir)) {
            for (FileStatus status : this.fs.listStatus(recoveryDir)) {
                if (GarbageCollectWriteAheadLogs.isUUID(status.getPath().getName())) {
                    sortedWALogs.add(status.getPath().getName());
                    continue;
                }
                log.debug((Object)("Ignoring file " + status.getPath() + " because it doesn't look like a uuid"));
            }
        }
        return sortedWALogs;
    }

    private static boolean isUUID(String name) {
        try {
            UUID.fromString(name);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

