/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class MergeStats {
    private static final Logger log = Logger.getLogger(MergeStats.class);
    MergeInfo info;
    int hosted = 0;
    int unassigned = 0;
    int chopped = 0;
    int needsToBeChopped = 0;
    int total = 0;
    boolean lowerSplit = false;
    boolean upperSplit = false;

    public MergeStats(MergeInfo info) {
        this.info = info;
        if (info.getState().equals((Object)MergeState.NONE)) {
            return;
        }
        if (info.getRange().getEndRow() == null) {
            this.upperSplit = true;
        }
        if (info.getRange().getPrevEndRow() == null) {
            this.lowerSplit = true;
        }
    }

    public MergeInfo getMergeInfo() {
        return this.info;
    }

    public void update(KeyExtent ke, TabletState state, boolean chopped, boolean hasWALs) {
        if (ke.isRootTablet()) {
            return;
        }
        if (this.info.getState().equals((Object)MergeState.NONE)) {
            return;
        }
        if (!this.upperSplit && this.info.getRange().getEndRow().equals((Object)ke.getPrevEndRow())) {
            log.info((Object)"Upper split found");
            this.upperSplit = true;
        }
        if (!this.lowerSplit && this.info.getRange().getPrevEndRow().equals((Object)ke.getEndRow())) {
            log.info((Object)"Lower split found");
            this.lowerSplit = true;
        }
        if (!this.info.overlaps(ke)) {
            return;
        }
        if (this.info.needsToBeChopped(ke)) {
            ++this.needsToBeChopped;
            if (chopped) {
                if (state.equals((Object)TabletState.HOSTED)) {
                    ++this.chopped;
                } else if (!hasWALs) {
                    ++this.chopped;
                }
            }
        }
        ++this.total;
        if (state.equals((Object)TabletState.HOSTED)) {
            ++this.hosted;
        }
        if (state.equals((Object)TabletState.UNASSIGNED)) {
            ++this.unassigned;
        }
    }

    public MergeState nextMergeState(Connector connector, CurrentState master) throws Exception {
        MergeState state = this.info.getState();
        if (state == MergeState.NONE) {
            return state;
        }
        if (this.total == 0) {
            log.trace((Object)("failed to see any tablets for this range, ignoring " + this.info.getRange()));
            return state;
        }
        log.info((Object)("Computing next merge state for " + this.info.getRange() + " which is presently " + (Object)((Object)state) + " isDelete : " + this.info.isDelete()));
        if (state == MergeState.STARTED) {
            state = MergeState.SPLITTING;
        }
        if (state == MergeState.SPLITTING) {
            log.info((Object)(this.hosted + " are hosted, total " + this.total));
            if (!this.info.isDelete() && this.total == 1) {
                log.info((Object)("Merge range is already contained in a single tablet " + this.info.getRange()));
                state = MergeState.COMPLETE;
            } else if (this.hosted == this.total) {
                if (this.info.isDelete()) {
                    if (!this.lowerSplit) {
                        log.info((Object)("Waiting for " + this.info + " lower split to occur " + this.info.getRange()));
                    } else if (!this.upperSplit) {
                        log.info((Object)("Waiting for " + this.info + " upper split to occur " + this.info.getRange()));
                    } else {
                        state = MergeState.WAITING_FOR_CHOPPED;
                    }
                } else {
                    state = MergeState.WAITING_FOR_CHOPPED;
                }
            } else {
                log.info((Object)("Waiting for " + this.hosted + " hosted tablets to be " + this.total + " " + this.info.getRange()));
            }
        }
        if (state == MergeState.WAITING_FOR_CHOPPED) {
            log.info((Object)(this.chopped + " tablets are chopped " + this.info.getRange()));
            if (this.chopped == this.needsToBeChopped) {
                state = MergeState.WAITING_FOR_OFFLINE;
            } else {
                log.info((Object)("Waiting for " + this.chopped + " chopped tablets to be " + this.needsToBeChopped + " " + this.info.getRange()));
            }
        }
        if (state == MergeState.WAITING_FOR_OFFLINE) {
            if (this.chopped != this.needsToBeChopped) {
                log.warn((Object)("Unexpected state: chopped tablets should be " + this.needsToBeChopped + " was " + this.chopped + " merge " + this.info.getRange()));
                state = MergeState.WAITING_FOR_CHOPPED;
            } else {
                log.info((Object)(this.chopped + " tablets are chopped, " + this.unassigned + " are offline " + this.info.getRange()));
                if (this.unassigned == this.total && this.chopped == this.needsToBeChopped) {
                    if (this.verifyMergeConsistency(connector, master)) {
                        state = MergeState.MERGING;
                    } else {
                        log.info((Object)("Merge consistency check failed " + this.info.getRange()));
                    }
                } else {
                    log.info((Object)("Waiting for " + this.unassigned + " unassigned tablets to be " + this.total + " " + this.info.getRange()));
                }
            }
        }
        if (state == MergeState.MERGING) {
            if (this.hosted != 0) {
                log.error((Object)("Unexpected state: hosted tablets should be zero " + this.hosted + " merge " + this.info.getRange()));
                state = MergeState.WAITING_FOR_OFFLINE;
            }
            if (this.unassigned != this.total) {
                log.error((Object)("Unexpected state: unassigned tablets should be " + this.total + " was " + this.unassigned + " merge " + this.info.getRange()));
                state = MergeState.WAITING_FOR_CHOPPED;
            }
            log.info((Object)(this.unassigned + " tablets are unassigned " + this.info.getRange()));
        }
        return state;
    }

    private boolean verifyMergeConsistency(Connector connector, CurrentState master) throws TableNotFoundException, IOException {
        MergeStats verify = new MergeStats(this.info);
        Scanner scanner = connector.createScanner("!METADATA", Constants.NO_AUTHS);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, master);
        KeyExtent extent = this.info.getRange();
        Text start = extent.getPrevEndRow();
        if (start == null) {
            start = new Text();
        }
        Text tableId = extent.getTableId();
        Text first = KeyExtent.getMetadataEntry((Text)tableId, (Text)start);
        Range range = new Range(first, false, null, true);
        if (extent.isMeta()) {
            range = new Range(new Key(first).followingKey(PartialKey.ROW), false, Constants.METADATA_ROOT_TABLET_KEYSPACE.getEndKey(), false);
        }
        scanner.setRange(range);
        KeyExtent prevExtent = null;
        log.debug((Object)("Scanning range " + range));
        for (Map.Entry entry : scanner) {
            TabletLocationState tls;
            try {
                tls = MetaDataTableScanner.createTabletLocationState((Key)entry.getKey(), (Value)entry.getValue());
            }
            catch (TabletLocationState.BadLocationStateException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
            log.debug((Object)("consistency check: " + tls + " walogs " + tls.walogs.size()));
            if (!tls.extent.getTableId().equals((Object)tableId)) break;
            if (!tls.walogs.isEmpty() && verify.getMergeInfo().needsToBeChopped(tls.extent)) {
                log.debug((Object)("failing consistency: needs to be chopped" + tls.extent));
                return false;
            }
            if (prevExtent == null) {
                if (tls.extent.getPrevEndRow() != null && tls.extent.getPrevEndRow().compareTo((BinaryComparable)start) > 0) {
                    log.debug((Object)("failing consistency: prev row is too high " + start));
                    return false;
                }
                if (tls.getState(master.onlineTabletServers()) != TabletState.UNASSIGNED) {
                    log.debug((Object)("failing consistency: assigned or hosted " + tls));
                    return false;
                }
            } else if (!tls.extent.isPreviousExtent(prevExtent)) {
                log.debug((Object)"hole in !METADATA");
                return false;
            }
            prevExtent = tls.extent;
            verify.update(tls.extent, tls.getState(master.onlineTabletServers()), tls.chopped, !tls.walogs.isEmpty());
            if (tls.extent.getPrevEndRow() == null || extent.getEndRow() == null || tls.extent.getPrevEndRow().compareTo((BinaryComparable)extent.getEndRow()) <= 0) continue;
            break;
        }
        log.debug((Object)("chopped " + this.chopped + " v.chopped " + verify.chopped + " unassigned " + this.unassigned + " v.unassigned " + verify.unassigned + " verify.total " + verify.total));
        return this.chopped == verify.chopped && this.unassigned == verify.unassigned && this.unassigned == verify.total;
    }

    public static void main(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(MergeStats.class.getName(), args, new Object[0]);
        Connector conn = opts.getConnector();
        Map tableIdMap = conn.tableOperations().tableIdMap();
        for (String table : tableIdMap.keySet()) {
            String tableId = (String)tableIdMap.get(table);
            String path = ZooUtil.getRoot((String)conn.getInstance().getInstanceID()) + "/tables" + "/" + tableId.toString() + "/merge";
            MergeInfo info = new MergeInfo();
            if (ZooReaderWriter.getInstance().exists(path)) {
                byte[] data = ZooReaderWriter.getInstance().getData(path, new Stat());
                DataInputBuffer in = new DataInputBuffer();
                in.reset(data, data.length);
                info.readFields((DataInput)in);
            }
            System.out.println(String.format("%25s  %10s %10s %s", new Object[]{table, info.state, info.operation, info.range}));
        }
    }
}

