/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;

public abstract class TabletStateStore
implements Iterable<TabletLocationState> {
    public abstract String name();

    @Override
    public abstract Iterator<TabletLocationState> iterator();

    public abstract void setFutureLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public abstract void setLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public abstract void unassign(Collection<TabletLocationState> var1) throws DistributedStoreException;

    public static void unassign(TabletLocationState tls) throws DistributedStoreException {
        TabletStateStore store = tls.extent.isRootTablet() ? new ZooTabletStateStore() : new MetaDataStateStore();
        store.unassign(Collections.singletonList(tls));
    }

    public static void setLocation(Assignment assignment) throws DistributedStoreException {
        TabletStateStore store = assignment.tablet.isRootTablet() ? new ZooTabletStateStore() : new MetaDataStateStore();
        store.setLocations(Collections.singletonList(assignment));
    }
}

