/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthorizor;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class ZKPermHandler
implements PermissionHandler {
    private static final Logger log = Logger.getLogger(ZKAuthorizor.class);
    private static PermissionHandler zkPermHandlerInstance = null;
    private String ZKUserPath;
    private String ZKTablePath;
    private final ZooCache zooCache = new ZooCache();
    private final String ZKUserSysPerms = "/System";
    private final String ZKUserTablePerms = "/Tables";

    public static synchronized PermissionHandler getInstance() {
        if (zkPermHandlerInstance == null) {
            zkPermHandlerInstance = new ZKPermHandler();
        }
        return zkPermHandlerInstance;
    }

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.ZKUserPath = ZKSecurityTool.getInstancePath(instanceId) + "/users";
        this.ZKTablePath = ZKSecurityTool.getInstancePath(instanceId) + "/tables";
    }

    @Override
    public boolean hasTablePermission(String user, String table, TablePermission permission) throws TableNotFoundException {
        byte[] serializedPerms;
        try {
            String path = this.ZKUserPath + "/" + user + "/Tables" + "/" + table;
            ZooReaderWriter.getRetryingInstance().sync(path);
            serializedPerms = ZooReaderWriter.getRetryingInstance().getData(path, null);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                try {
                    ZooReaderWriter.getRetryingInstance().getData(this.ZKTablePath + "/" + table, null);
                    return false;
                }
                catch (InterruptedException ex) {
                    log.warn((Object)"Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
                    return false;
                }
                catch (KeeperException ex) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        throw new TableNotFoundException(null, table, "while checking permissions");
                    }
                    log.warn((Object)"Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
                    return false;
                }
            }
            log.warn((Object)"Unhandled KeeperException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn((Object)"Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        if (serializedPerms != null) {
            return ZKSecurityTool.convertTablePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    @Override
    public boolean hasCachedTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
        if (serializedPerms != null) {
            return ZKSecurityTool.convertTablePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        block6: {
            try {
                byte[] permBytes = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
                Set<SystemPermission> perms = permBytes == null ? new TreeSet<SystemPermission>() : ZKSecurityTool.convertSystemPermissions(permBytes);
                if (!perms.add(permission)) break block6;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear();
                    ZooReaderWriter.getRetryingInstance().putPersistentData(this.ZKUserPath + "/" + user + "/System", ZKSecurityTool.convertSystemPermissions(perms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error((Object)e, (Throwable)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException {
        block6: {
            byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
            Set<TablePermission> tablePerms = serializedPerms != null ? ZKSecurityTool.convertTablePermissions(serializedPerms) : new TreeSet<TablePermission>();
            try {
                if (!tablePerms.add(permission)) break block6;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
                    IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
                    zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(tablePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error((Object)e, (Throwable)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        block7: {
            byte[] sysPermBytes = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
            if (sysPermBytes == null) {
                return;
            }
            Set<SystemPermission> sysPerms = ZKSecurityTool.convertSystemPermissions(sysPermBytes);
            try {
                if (!sysPerms.remove(permission)) break block7;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear();
                    ZooReaderWriter.getRetryingInstance().putPersistentData(this.ZKUserPath + "/" + user + "/System", ZKSecurityTool.convertSystemPermissions(sysPerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error((Object)e, (Throwable)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void revokeTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
        if (serializedPerms == null) {
            return;
        }
        Set<TablePermission> tablePerms = ZKSecurityTool.convertTablePermissions(serializedPerms);
        try {
            if (tablePerms.remove(permission)) {
                this.zooCache.clear();
                IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
                if (tablePerms.size() == 0) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZooUtil.NodeMissingPolicy.SKIP);
                } else {
                    zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(tablePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTablePermissions(String table) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
                for (String user : this.zooCache.getChildren(this.ZKUserPath)) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZooUtil.NodeMissingPolicy.SKIP);
                }
            }
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            throw new AccumuloSecurityException("unknownUser", SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initializeSecurity(TCredentials itw, String rootuser) throws AccumuloSecurityException {
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        TreeSet<SystemPermission> rootPerms = new TreeSet<SystemPermission>();
        for (SystemPermission p : SystemPermission.values()) {
            rootPerms.add(p);
        }
        HashMap<String, Set<TablePermission>> tablePerms = new HashMap<String, Set<TablePermission>>();
        tablePerms.put("!0", Collections.singleton(TablePermission.ALTER_TABLE));
        try {
            if (!zoo.exists(this.ZKUserPath)) {
                zoo.putPersistentData(this.ZKUserPath, rootuser.getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
            }
            this.initUser(rootuser);
            zoo.putPersistentData(this.ZKUserPath + "/" + rootuser + "/System", ZKSecurityTool.convertSystemPermissions(rootPerms), ZooUtil.NodeExistsPolicy.FAIL);
            for (Map.Entry entry : tablePerms.entrySet()) {
                this.createTablePerm(rootuser, (String)entry.getKey(), (Set)entry.getValue());
            }
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        try {
            zoo.putPersistentData(this.ZKUserPath + "/" + user, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Tables", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTablePerm(String user, String table, Set<TablePermission> perms) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            ZooReaderWriter.getRetryingInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(perms), ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/System", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables", ZooUtil.NodeMissingPolicy.SKIP);
                this.zooCache.clear(this.ZKUserPath + "/" + user);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    @Override
    public boolean hasSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        byte[] perms;
        try {
            String path = this.ZKUserPath + "/" + user + "/System";
            ZooReaderWriter.getRetryingInstance().sync(path);
            perms = ZooReaderWriter.getRetryingInstance().getData(path, null);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                return false;
            }
            log.warn((Object)"Unhandled KeeperException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn((Object)"Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        if (perms == null) {
            return false;
        }
        return ZKSecurityTool.convertSystemPermissions(perms).contains(permission);
    }

    @Override
    public boolean hasCachedSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        byte[] perms = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
        if (perms == null) {
            return false;
        }
        return ZKSecurityTool.convertSystemPermissions(perms).contains(permission);
    }

    @Override
    public boolean validSecurityHandlers(Authenticator authent, Authorizor author) {
        return true;
    }

    @Override
    public void initTable(String table) throws AccumuloSecurityException {
    }
}

