/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.util.Random;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class UniqueNameAllocator {
    private long next = 0L;
    private long maxAllocated = 0L;
    private String nextNamePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/next_file";
    private Random rand = new Random();
    private static UniqueNameAllocator instance = null;

    private UniqueNameAllocator() {
    }

    public synchronized String getNextName() {
        while (this.next >= this.maxAllocated) {
            final int allocate = 100 + this.rand.nextInt(100);
            try {
                byte[] max = ZooReaderWriter.getRetryingInstance().mutate(this.nextNamePath, null, ZooUtil.PRIVATE, new ZooReaderWriter.Mutator(){

                    public byte[] mutate(byte[] currentValue) throws Exception {
                        long l = Long.parseLong(new String(currentValue), 36);
                        return Long.toString(l += (long)allocate, 36).getBytes();
                    }
                });
                this.maxAllocated = Long.parseLong(new String(max), 36);
                this.next = this.maxAllocated - (long)allocate;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new String(FastFormat.toZeroPaddedString((long)this.next++, (int)7, (int)36, (byte[])new byte[0]));
    }

    public static synchronized UniqueNameAllocator getInstance() {
        if (instance == null) {
            instance = new UniqueNameAllocator();
        }
        return instance;
    }
}

