/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.AddressUtil;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.log4j.Logger;

public class Admin {
    private static final Logger log = Logger.getLogger(Admin.class);

    public static void main(String[] args) {
        AdminOpts opts = new AdminOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName(Admin.class.getName());
        StopCommand stopOpts = new StopCommand();
        cl.addCommand("stop", (Object)stopOpts);
        StopMasterCommand stopMasterOpts = new StopMasterCommand();
        cl.addCommand("stopMaster", (Object)stopMasterOpts);
        StopAllCommand stopAllOpts = new StopAllCommand();
        cl.addCommand("stopAll", (Object)stopAllOpts);
        cl.parse(args);
        if (opts.help || cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        Instance instance = opts.getInstance();
        try {
            AuthenticationToken token;
            String principal;
            if (opts.getToken() == null) {
                principal = SecurityConstants.getSystemPrincipal();
                token = SecurityConstants.getSystemToken();
            } else {
                principal = opts.principal;
                token = opts.getToken();
            }
            if (cl.getParsedCommand().equals("stop")) {
                Admin.stopTabletServer(instance, CredentialHelper.create((String)principal, (AuthenticationToken)token, (String)instance.getInstanceID()), stopOpts.args, opts.force);
            } else {
                boolean everything = cl.getParsedCommand().equals("stopAll");
                if (everything) {
                    Admin.flushAll(instance, principal, token);
                }
                Admin.stopServer(instance, CredentialHelper.create((String)principal, (AuthenticationToken)token, (String)instance.getInstanceID()), everything);
            }
        }
        catch (AccumuloException e) {
            log.error((Object)e, (Throwable)e);
            System.exit(1);
        }
        catch (AccumuloSecurityException e) {
            log.error((Object)e, (Throwable)e);
            System.exit(2);
        }
    }

    private static void flushAll(final Instance instance, final String principal, final AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        final AtomicInteger flushesStarted = new AtomicInteger(0);
        Runnable flushTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Connector conn = instance.getConnector(principal, token);
                    Set tables = conn.tableOperations().tableIdMap().keySet();
                    for (String table : tables) {
                        if (table.equals("!METADATA")) continue;
                        try {
                            conn.tableOperations().flush(table, null, null, false);
                            flushesStarted.incrementAndGet();
                        }
                        catch (TableNotFoundException e) {}
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to intiate flush " + e.getMessage()));
                }
            }
        };
        Thread flusher = new Thread(flushTask);
        flusher.setDaemon(true);
        flusher.start();
        long start = System.currentTimeMillis();
        try {
            flusher.join(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while (flusher.isAlive() && System.currentTimeMillis() - start < 15000L) {
            int flushCount = flushesStarted.get();
            try {
                flusher.join(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (flushCount != flushesStarted.get()) continue;
            break;
        }
    }

    private static void stopServer(Instance instance, final TCredentials credentials, final boolean tabletServersToo) throws AccumuloException, AccumuloSecurityException {
        MasterClient.execute((Instance)HdfsZooInstance.getInstance(), (ClientExec)new ClientExec<MasterClientService.Client>(){

            public void execute(MasterClientService.Client client) throws Exception {
                client.shutdown(Tracer.traceInfo(), credentials, tabletServersToo);
            }
        });
    }

    private static void stopTabletServer(Instance instance, final TCredentials creds, List<String> servers, final boolean force) throws AccumuloException, AccumuloSecurityException {
        for (String server : servers) {
            InetSocketAddress address = AddressUtil.parseAddress(server, Property.TSERV_CLIENTPORT);
            final String finalServer = org.apache.accumulo.core.util.AddressUtil.toString((InetSocketAddress)address);
            log.info((Object)("Stopping server " + finalServer));
            MasterClient.execute((Instance)HdfsZooInstance.getInstance(), (ClientExec)new ClientExec<MasterClientService.Client>(){

                public void execute(MasterClientService.Client client) throws Exception {
                    client.shutdownTabletServer(Tracer.traceInfo(), creds, finalServer, force);
                }
            });
        }
    }

    @Parameters(commandDescription="stop all the servers")
    static class StopAllCommand {
        StopAllCommand() {
        }
    }

    @Parameters(commandDescription="stop the master")
    static class StopMasterCommand {
        StopMasterCommand() {
        }
    }

    @Parameters(commandDescription="stop the tablet server on the given hosts")
    static class StopCommand {
        @Parameter(description="<host> {<host> ... }")
        List<String> args = new ArrayList<String>();

        StopCommand() {
        }
    }

    static class AdminOpts
    extends ClientOpts {
        @Parameter(names={"-f", "--force"}, description="force the given server to stop by removing its lock")
        boolean force = false;

        AdminOpts() {
        }
    }
}

