/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class TabletServerLocks {
    public static void main(String[] args) throws Exception {
        String tserverPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/tservers";
        Opts opts = new Opts();
        opts.parseArgs(TabletServerLocks.class.getName(), args, new Object[0]);
        if (opts.list) {
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            List tabletServers = zoo.getChildren(tserverPath);
            for (String tabletServer : tabletServers) {
                byte[] lockData = ZooLock.getLockData((String)(tserverPath + "/" + tabletServer));
                String holder = null;
                if (lockData != null) {
                    holder = new String(lockData);
                }
                System.out.printf("%32s %16s%n", tabletServer, holder);
            }
        } else if (opts.delete != null) {
            ZooLock.deleteLock(tserverPath + "/" + args[1]);
        } else {
            System.out.println("Usage : " + TabletServerLocks.class.getName() + " -list|-delete <tserver lock>");
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-list"})
        boolean list = false;
        @Parameter(names={"-delete"})
        String delete = null;

        Opts() {
        }
    }
}

