/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public interface FetchFormatter<T>
extends Closeable {
    public void initialize(Configuration var1, Properties var2) throws Exception;

    public T convert(Object var1, ObjectInspector var2) throws Exception;

    public static class ThriftFormatter
    implements FetchFormatter<Object> {
        int protocol;

        @Override
        public void initialize(Configuration hconf, Properties props) throws Exception {
            this.protocol = hconf.getInt("output.protocol", 0);
        }

        @Override
        public Object convert(Object row, ObjectInspector rowOI) throws Exception {
            StructObjectInspector structOI = (StructObjectInspector)rowOI;
            List fields = structOI.getAllStructFieldRefs();
            Object[] converted = new Object[fields.size()];
            for (int i = 0; i < converted.length; ++i) {
                StructField fieldRef = (StructField)fields.get(i);
                Object field = structOI.getStructFieldData(row, fieldRef);
                converted[i] = field == null ? null : SerDeUtils.toThriftPayload((Object)field, (ObjectInspector)fieldRef.getFieldObjectInspector(), (int)this.protocol);
            }
            return converted;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

