/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;

public class HivePreFilteringRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog((String)HivePreFilteringRule.class.getName());
    public static final HivePreFilteringRule INSTANCE = new HivePreFilteringRule();
    private final RelFactories.FilterFactory filterFactory = HiveFilter.DEFAULT_FILTER_FACTORY;
    private static final Set<String> COMPARISON_UDFS = Sets.newHashSet((Object[])new String[]{GenericUDFOPEqual.class.getAnnotation(Description.class).name(), GenericUDFOPEqualNS.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPNotEqual.class.getAnnotation(Description.class).name()});
    private static final String IN_UDF = GenericUDFIn.class.getAnnotation(Description.class).name();
    private static final String BETWEEN_UDF = GenericUDFBetween.class.getAnnotation(Description.class).name();

    private HivePreFilteringRule() {
        super(HivePreFilteringRule.operand(Filter.class, (RelOptRuleOperand)HivePreFilteringRule.operand(RelNode.class, (RelOptRuleOperandChildren)HivePreFilteringRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelNode filterChild = call.rel(1);
        if (filterChild instanceof TableScan) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition());
        List<Object> commonOperands = new ArrayList();
        switch (condition.getKind()) {
            case AND: {
                ImmutableList operands = RexUtil.flattenAnd((Iterable)((RexCall)condition).getOperands());
                for (RexNode operand : operands) {
                    if (operand.getKind() != SqlKind.OR) continue;
                    commonOperands.addAll(HivePreFilteringRule.extractCommonOperands(rexBuilder, operand));
                }
                break;
            }
            case OR: {
                commonOperands = HivePreFilteringRule.extractCommonOperands(rexBuilder, condition);
                break;
            }
            default: {
                return;
            }
        }
        if (commonOperands.isEmpty()) {
            return;
        }
        RelOptPredicateList predicates = RelMetadataQuery.getPulledUpPredicates((RelNode)filter);
        ArrayList<RexNode> newConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : commonOperands) {
            boolean found = false;
            for (RexNode conjunct : predicates.pulledUpPredicates) {
                if (!rexNode.toString().equals(conjunct.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newConjuncts.add(rexNode);
        }
        if (newConjuncts.isEmpty()) {
            return;
        }
        RexNode newCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)RexUtil.composeConjunction((RexBuilder)rexBuilder, newConjuncts, (boolean)false));
        RelNode relNode = this.filterFactory.createFilter(filterChild, newCondition);
        RelNode newTopFilter = this.filterFactory.createFilter(relNode, condition);
        call.transformTo(newTopFilter);
    }

    private static List<RexNode> extractCommonOperands(RexBuilder rexBuilder, RexNode condition) {
        assert (condition.getKind() == SqlKind.OR);
        LinkedHashMultimap reductionCondition = LinkedHashMultimap.create();
        ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)condition).getOperands());
        for (RexNode operand : operands) {
            RexNode operandCNF = RexUtil.toCnf((RexBuilder)rexBuilder, (RexNode)operand);
            List conjunctions = RelOptUtil.conjunctions((RexNode)operandCNF);
            boolean addedToReductionCondition = false;
            for (RexNode conjunction : conjunctions) {
                if (!(conjunction instanceof RexCall)) continue;
                RexCall conjCall = (RexCall)conjunction;
                if (COMPARISON_UDFS.contains(conjCall.getOperator().getName())) {
                    if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                        reductionCondition.put((Object)((RexNode)conjCall.operands.get(0)).toString(), (Object)conjCall);
                        addedToReductionCondition = true;
                        continue;
                    }
                    if (!(conjCall.operands.get(1) instanceof RexInputRef) || !(conjCall.operands.get(0) instanceof RexLiteral)) continue;
                    reductionCondition.put((Object)((RexNode)conjCall.operands.get(1)).toString(), (Object)conjCall);
                    addedToReductionCondition = true;
                    continue;
                }
                if (conjCall.getOperator().getName().equals(IN_UDF)) {
                    reductionCondition.put((Object)((RexNode)conjCall.operands.get(0)).toString(), (Object)conjCall);
                    addedToReductionCondition = true;
                    continue;
                }
                if (!conjCall.getOperator().getName().equals(BETWEEN_UDF)) continue;
                reductionCondition.put((Object)((RexNode)conjCall.operands.get(1)).toString(), (Object)conjCall);
                addedToReductionCondition = true;
            }
            if (addedToReductionCondition) continue;
            return new ArrayList<RexNode>();
        }
        ArrayList<RexNode> commonOperands = new ArrayList<RexNode>();
        for (Map.Entry pair : reductionCondition.asMap().entrySet()) {
            if (((Collection)pair.getValue()).size() != operands.size()) continue;
            commonOperands.add(RexUtil.composeDisjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)pair.getValue()), (boolean)false));
        }
        return commonOperands;
    }
}

