/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;
import org.apache.hadoop.hive.ql.plan.ptf.ShapeDetails;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;

@Explain(displayName="Partition table definition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class PartitionedTableFunctionDef
extends PTFInputDef {
    private String name;
    private String resolverClassName;
    private ShapeDetails rawInputShape;
    private boolean carryForwardNames;
    private PTFInputDef input;
    private List<PTFExpressionDef> args;
    private PartitionDef partition;
    private OrderDef order;
    private TableFunctionEvaluator tFunction;
    boolean transformsRawInput;
    private transient List<String> referencedColumns;

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ShapeDetails getRawInputShape() {
        return this.rawInputShape;
    }

    @Explain(displayName="raw input shape")
    public ShapeDetails getRawInputShapeExplain() {
        return this.rawInputShape;
    }

    public void setRawInputShape(ShapeDetails rawInputShape) {
        this.rawInputShape = rawInputShape;
    }

    public boolean isCarryForwardNames() {
        return this.carryForwardNames;
    }

    public void setCarryForwardNames(boolean carryForwardNames) {
        this.carryForwardNames = carryForwardNames;
    }

    @Override
    public PTFInputDef getInput() {
        return this.input;
    }

    public void setInput(PTFInputDef input) {
        this.input = input;
    }

    public PartitionDef getPartition() {
        return this.partition;
    }

    @Explain(displayName="partition by", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPartitionExplain() {
        if (this.partition == null || this.partition.getExpressions() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (PTFExpressionDef expression : this.partition.getExpressions()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(expression.getExprNode().getExprString());
        }
        return builder.toString();
    }

    public void setPartition(PartitionDef partition) {
        this.partition = partition;
    }

    public OrderDef getOrder() {
        return this.order;
    }

    public void setOrder(OrderDef order) {
        this.order = order;
    }

    @Explain(displayName="order by", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOrderExplain() {
        if (this.order == null || this.order.getExpressions() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (OrderExpressionDef expression : this.order.getExpressions()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(expression.getExprNode().getExprString());
            if (expression.getOrder() != PTFInvocationSpec.Order.DESC) continue;
            builder.append("(DESC)");
        }
        return builder.toString();
    }

    public TableFunctionEvaluator getTFunction() {
        return this.tFunction;
    }

    public void setTFunction(TableFunctionEvaluator tFunction) {
        this.tFunction = tFunction;
    }

    public List<PTFExpressionDef> getArgs() {
        return this.args;
    }

    public void setArgs(List<PTFExpressionDef> args) {
        this.args = args;
    }

    @Explain(displayName="arguments", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getArgsExplain() {
        if (this.args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (PTFExpressionDef expression : this.args) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(expression.getExprNode().getExprString());
        }
        return builder.toString();
    }

    public void addArg(PTFExpressionDef arg) {
        this.args = this.args == null ? new ArrayList() : this.args;
        this.args.add(arg);
    }

    public PartitionedTableFunctionDef getStartOfChain() {
        if (this.input instanceof PartitionedTableFunctionDef) {
            return ((PartitionedTableFunctionDef)this.input).getStartOfChain();
        }
        return this;
    }

    @Explain(displayName="transforms raw input", displayOnlyOnTrue=true)
    public boolean isTransformsRawInput() {
        return this.transformsRawInput;
    }

    public void setTransformsRawInput(boolean transformsRawInput) {
        this.transformsRawInput = transformsRawInput;
    }

    public String getResolverClassName() {
        return this.resolverClassName;
    }

    public void setResolverClassName(String resolverClassName) {
        this.resolverClassName = resolverClassName;
    }

    @Explain(displayName="referenced columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    public void setReferencedColumns(List<String> referencedColumns) {
        this.referencedColumns = referencedColumns;
    }
}

