/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNode
extends Node {
    private final Node conditionNode;

    public NotNode(ISourcePosition position, Node conditionNode) {
        super(position);
        assert (conditionNode != null) : "conditionNode is not null";
        this.conditionNode = conditionNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NOTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNotNode(this);
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public List<Node> childNodes() {
        return NotNode.createList(this.conditionNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.newBoolean(!this.conditionNode.interpret(runtime2, context, self, aBlock).isTrue());
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        ByteList definition = super.definition(runtime2, context, self, aBlock);
        return RuntimeHelpers.getDefinedNot(runtime2, definition);
    }
}

