/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.SplitSizeEstimator;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezMapReduceSplitsGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(TezMapReduceSplitsGrouper.class);
    public static final String TEZ_GROUPING_SPLIT_COUNT = "tez.grouping.split-count";
    public static final String TEZ_GROUPING_SPLIT_BY_LENGTH = "tez.grouping.by-length";
    public static final boolean TEZ_GROUPING_SPLIT_BY_LENGTH_DEFAULT = true;
    public static final String TEZ_GROUPING_SPLIT_BY_COUNT = "tez.grouping.by-count";
    public static final boolean TEZ_GROUPING_SPLIT_BY_COUNT_DEFAULT = false;
    public static final String TEZ_GROUPING_SPLIT_WAVES = "tez.grouping.split-waves";
    public static final float TEZ_GROUPING_SPLIT_WAVES_DEFAULT = 1.7f;
    public static final String TEZ_GROUPING_SPLIT_MAX_SIZE = "tez.grouping.max-size";
    public static final long TEZ_GROUPING_SPLIT_MAX_SIZE_DEFAULT = 0x40000000L;
    public static final String TEZ_GROUPING_SPLIT_MIN_SIZE = "tez.grouping.min-size";
    public static final long TEZ_GROUPING_SPLIT_MIN_SIZE_DEFAULT = 0x3200000L;
    public static final String TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION = "tez.grouping.rack-split-reduction";
    public static final float TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION_DEFAULT = 0.75f;
    public static final String TEZ_GROUPING_REPEATABLE = "tez.grouping.repeatable";
    public static final boolean TEZ_GROUPING_REPEATABLE_DEFAULT = true;
    private static final SplitSizeEstimator DEFAULT_SPLIT_ESTIMATOR = new DefaultSplitSizeEstimator();

    Map<String, LocationHolder> createLocationsMap(Configuration conf) {
        if (conf.getBoolean(TEZ_GROUPING_REPEATABLE, true)) {
            return new TreeMap<String, LocationHolder>();
        }
        return new HashMap<String, LocationHolder>();
    }

    public List<InputSplit> getGroupedSplits(Configuration conf, List<InputSplit> originalSplits, int desiredNumSplits, String wrappedInputFormatName) throws IOException, InterruptedException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, null);
    }

    public List<InputSplit> getGroupedSplits(Configuration conf, List<InputSplit> originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator) throws IOException, InterruptedException {
        LOG.info("Grouping splits in Tez");
        int configNumSplits = conf.getInt(TEZ_GROUPING_SPLIT_COUNT, 0);
        if (configNumSplits > 0) {
            desiredNumSplits = configNumSplits;
            LOG.info("Desired numSplits overridden by config to: " + desiredNumSplits);
        }
        if (estimator == null) {
            estimator = DEFAULT_SPLIT_ESTIMATOR;
        }
        if (configNumSplits <= 0 && originalSplits != null && originalSplits.size() != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            long totalLength = 0L;
            for (InputSplit split : originalSplits) {
                totalLength += estimator.getEstimatedSize(split);
            }
            int splitCount = desiredNumSplits > 0 ? desiredNumSplits : originalSplits.size();
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = conf.getLong(TEZ_GROUPING_SPLIT_MAX_SIZE, 0x40000000L);
            if (maxLengthPerGroup < (minLengthPerGroup = conf.getLong(TEZ_GROUPING_SPLIT_MIN_SIZE, 0x3200000L)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info("Desired splits: " + desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.size());
                desiredNumSplits = newDesiredNumSplits;
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                LOG.info("Desired splits: " + desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.size());
                desiredNumSplits = newDesiredNumSplits;
            }
        }
        ArrayList<InputSplit> groupedSplits = null;
        if (desiredNumSplits == 0 || originalSplits.size() == 0 || desiredNumSplits >= originalSplits.size()) {
            LOG.info("Using original number of splits: " + originalSplits.size() + " desired splits: " + desiredNumSplits);
            groupedSplits = new ArrayList(originalSplits.size());
            for (InputSplit split : originalSplits) {
                TezGroupedSplit newSplit = new TezGroupedSplit(1, wrappedInputFormatName, split.getLocations());
                newSplit.addSplit(split);
                groupedSplits.add(newSplit);
            }
            return groupedSplits;
        }
        String emptyLocation = "EmptyLocation";
        String[] emptyLocations = new String[]{emptyLocation};
        groupedSplits = new ArrayList<InputSplit>(desiredNumSplits);
        long totalLength = 0L;
        Map<String, LocationHolder> distinctLocations = this.createLocationsMap(conf);
        for (InputSplit split : originalSplits) {
            totalLength += estimator.getEstimatedSize(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                if (location == null) {
                    location = emptyLocation;
                }
                distinctLocations.put(location, null);
            }
        }
        long lengthPerGroup = totalLength / (long)desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.size() / numNodeLocations;
        int numSplitsInGroup = originalSplits.size() / desiredNumSplits;
        for (String location : distinctLocations.keySet()) {
            distinctLocations.put(location, new LocationHolder(numSplitsPerLocation + 1));
        }
        HashSet<String> locSet = new HashSet<String>();
        for (InputSplit split : originalSplits) {
            locSet.clear();
            SplitHolder splitHolder = new SplitHolder(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                if (location == null) {
                    location = emptyLocation;
                }
                locSet.add(location);
            }
            for (String location : locSet) {
                LocationHolder holder = distinctLocations.get(location);
                holder.splits.add(splitHolder);
            }
        }
        boolean groupByLength = conf.getBoolean(TEZ_GROUPING_SPLIT_BY_LENGTH, true);
        boolean groupByCount = conf.getBoolean(TEZ_GROUPING_SPLIT_BY_COUNT, false);
        if (!groupByLength && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.grouping.by-length, tez.grouping.by-count");
        }
        LOG.info("Desired numSplits: " + desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.size() + " . Grouping by length: " + groupByLength + " count: " + groupByCount);
        int splitsProcessed = 0;
        ArrayList<SplitHolder> group = new ArrayList<SplitHolder>(numSplitsInGroup);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (splitsProcessed < originalSplits.size()) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry<String, LocationHolder> entry : distinctLocations.entrySet()) {
                group.clear();
                groupLocationSet.clear();
                String location = entry.getKey();
                LocationHolder holder = entry.getValue();
                SplitHolder splitHolder = holder.getUnprocessedHeadSplit();
                if (splitHolder == null) continue;
                int oldHeadIndex = holder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    group.add(splitHolder);
                    holder.incrementHeadIndex();
                } while ((splitHolder = holder.getUnprocessedHeadSplit()) != null && (!groupByLength || (groupLength += estimator.getEstimatedSize(splitHolder.split)) + estimator.getEstimatedSize(splitHolder.split) <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!holder.isEmpty() || allowSmallGroups || groupByLength && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    holder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                String[] groupLocation = new String[]{location};
                if (location == emptyLocation) {
                    groupLocation = null;
                } else if (doingRackLocal) {
                    for (SplitHolder splitH : group) {
                        String[] locations = splitH.split.getLocations();
                        if (locations == null) continue;
                        for (String loc : locations) {
                            if (loc == null) continue;
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray(groupLocation);
                }
                TezGroupedSplit groupedSplit = new TezGroupedSplit(group.size(), wrappedInputFormatName, groupLocation, doingRackLocal && location != emptyLocation ? location : null);
                for (SplitHolder groupedSplitHolder : group) {
                    groupedSplit.addSplit(groupedSplitHolder.split);
                    Preconditions.checkState((!groupedSplitHolder.isProcessed ? 1 : 0) != 0, (Object)("Duplicates in grouping at location: " + location));
                    groupedSplitHolder.isProcessed = true;
                    ++splitsProcessed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Grouped " + group.size() + " length: " + groupedSplit.getLength() + " split at: " + location);
                }
                groupedSplits.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.size() - splitsProcessed;
                HashSet<InputSplit> remainingSplits = new HashSet<InputSplit>(numRemainingSplits);
                for (Map.Entry<String, LocationHolder> entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitHolder splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder.split);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                Map<String, LocationHolder> rackLocations = this.createLocationsMap(conf);
                for (String location : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location != emptyLocation) {
                        rack = RackResolver.resolve((String)location).getNetworkLocation();
                    }
                    locToRackMap.put(location, rack);
                    if (rackLocations.get(rack) != null) continue;
                    rackLocations.put(rack, new LocationHolder(numRemainingSplits));
                }
                distinctLocations.clear();
                HashSet rackSet = new HashSet(rackLocations.size());
                int numRackSplitsToGroup = remainingSplits.size();
                for (InputSplit split : originalSplits) {
                    if (numRackSplitsToGroup == 0) break;
                    if (!remainingSplits.contains(split)) continue;
                    --numRackSplitsToGroup;
                    rackSet.clear();
                    SplitHolder splitHolder = new SplitHolder(split);
                    String[] locations = split.getLocations();
                    if (locations == null || locations.length == 0) {
                        locations = emptyLocations;
                    }
                    for (String location : locations) {
                        if (location == null) {
                            location = emptyLocation;
                        }
                        rackSet.add(locToRackMap.get(location));
                    }
                    for (String rack : rackSet) {
                        rackLocations.get((Object)rack).splits.add(splitHolder);
                    }
                }
                remainingSplits.clear();
                distinctLocations = rackLocations;
                float rackSplitReduction = conf.getFloat(TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION, 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info("Doing rack local after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup);
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size());
        }
        LOG.info("Number of splits desired: " + desiredNumSplits + " created: " + groupedSplits.size() + " splitsProcessed: " + splitsProcessed);
        return groupedSplits;
    }

    public static TezMRSplitsGrouperConfigBuilder createConfigBuilder(Configuration conf) {
        return new TezMRSplitsGrouperConfigBuilder(conf);
    }

    public static final class TezMRSplitsGrouperConfigBuilder {
        private final Configuration conf;

        private TezMRSplitsGrouperConfigBuilder(@Nullable Configuration conf) {
            if (conf == null) {
                conf = new Configuration(false);
            }
            this.conf = conf;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitCount(int count) {
            this.conf.setInt(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_COUNT, count);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByCount(boolean enabled) {
            this.conf.setBoolean(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_BY_COUNT, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByLength(boolean enabled) {
            this.conf.setBoolean(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_BY_LENGTH, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitWaves(float multiplier) {
            this.conf.setFloat(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_WAVES, multiplier);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingRackSplitSizeReduction(float rackSplitSizeReduction) {
            this.conf.setFloat(TezMapReduceSplitsGrouper.TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION, rackSplitSizeReduction);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingSplitSize(long lowerBound, long upperBound) {
            this.conf.setLong(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_MIN_SIZE, lowerBound);
            this.conf.setLong(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_MAX_SIZE, upperBound);
            return this;
        }

        public Configuration build() {
            return this.conf;
        }
    }

    static final class DefaultSplitSizeEstimator
    implements SplitSizeEstimator {
        DefaultSplitSizeEstimator() {
        }

        @Override
        public long getEstimatedSize(InputSplit split) throws InterruptedException, IOException {
            return split.getLength();
        }
    }

    static class LocationHolder {
        List<SplitHolder> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitHolder>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitHolder getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitHolder holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }

    static class SplitHolder {
        InputSplit split;
        boolean isProcessed = false;

        SplitHolder(InputSplit split) {
            this.split = split;
        }
    }
}

