/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TransactionWatcher {
    private static final Logger log = Logger.getLogger(TransactionWatcher.class);
    private final Map<Long, AtomicInteger> counts = new HashMap<Long, AtomicInteger>();
    private final Arbitrator arbitrator;

    public TransactionWatcher(Arbitrator arbitrator) {
        this.arbitrator = arbitrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(String ztxBulk, long tid, Callable<T> callable) throws Exception {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            if (!this.arbitrator.transactionAlive(ztxBulk, tid)) {
                throw new Exception("Transaction " + tid + " of type " + ztxBulk + " is no longer active");
            }
            AtomicInteger count = this.counts.get(tid);
            if (count == null) {
                count = new AtomicInteger();
                this.counts.put(tid, count);
            }
            count.incrementAndGet();
        }
        try {
            map = callable.call();
            return (T)map;
        }
        finally {
            Map<Long, AtomicInteger> map2 = this.counts;
            synchronized (map2) {
                AtomicInteger count = this.counts.get(tid);
                if (count == null) {
                    log.error((Object)("unexpected missing count for transaction" + tid));
                } else if (count.decrementAndGet() == 0) {
                    this.counts.remove(tid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(long tid) {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            log.debug((Object)("Transactions in progress " + this.counts));
            AtomicInteger count = this.counts.get(tid);
            return count != null && count.get() > 0;
        }
    }

    public static interface Arbitrator {
        public boolean transactionAlive(String var1, long var2) throws Exception;

        public boolean transactionComplete(String var1, long var2) throws Exception;
    }
}

