/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskAttemptID
extends TezID {
    public static final String ATTEMPT = "attempt";
    private TezTaskID taskId;
    private static LoadingCache<TezTaskAttemptID, TezTaskAttemptID> taskAttemptIDCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<TezTaskAttemptID, TezTaskAttemptID>(){

        public TezTaskAttemptID load(TezTaskAttemptID key) throws Exception {
            return key;
        }
    });
    protected static final ThreadLocal<NumberFormat> tezTaskAttemptIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(1);
            return fmt;
        }
    };

    public TezTaskAttemptID() {
    }

    public static TezTaskAttemptID getInstance(TezTaskID taskID, int id) {
        return (TezTaskAttemptID)taskAttemptIDCache.getUnchecked((Object)new TezTaskAttemptID(taskID, id));
    }

    @InterfaceAudience.Private
    public static void clearCache() {
        taskAttemptIDCache.invalidateAll();
        taskAttemptIDCache.cleanUp();
    }

    private TezTaskAttemptID(TezTaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TezTaskID getTaskID() {
        return this.taskId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        return this.taskId.equals(that.taskId);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.taskId.appendTo(builder).append('_').append(this.id);
    }

    @Override
    public int hashCode() {
        return this.taskId.hashCode() * 539501 + this.id;
    }

    @Override
    public int compareTo(TezID o) {
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(ATTEMPT)).toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskId = TezTaskID.readTezTaskID(in);
        super.readFields(in);
    }

    public static TezTaskAttemptID readTezTaskAttemptID(DataInput in) throws IOException {
        TezTaskID taskID = TezTaskID.readTezTaskID(in);
        int attemptIdInt = TezID.readID(in);
        return TezTaskAttemptID.getInstance(taskID, attemptIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        super.write(out);
    }

    public static TezTaskAttemptID fromString(String taIdStr) {
        try {
            String[] split = taIdStr.split("_");
            String rmId = split[1];
            int appId = TezDAGID.tezAppIdFormat.get().parse(split[2]).intValue();
            int dagId = TezDAGID.tezDagIdFormat.get().parse(split[3]).intValue();
            int vId = TezVertexID.tezVertexIdFormat.get().parse(split[4]).intValue();
            int taskId = TezTaskID.tezTaskIdFormat.get().parse(split[5]).intValue();
            int id = tezTaskAttemptIdFormat.get().parse(split[6]).intValue();
            return TezTaskAttemptID.getInstance(TezTaskID.getInstance(TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), vId), taskId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

