/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTuple;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleMaker;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.DefaultIndexableLoader;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.logical.relational.LOJoin;

public class POMergeJoin
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(POMergeJoin.class);
    private static final long serialVersionUID = 1L;
    private static final String keyOrderReminder = "Remember that you should not change the order of keys before a merge join in a FOREACH or manipulate join keys in a UDF in a way that would change the sort order. UDFs in a FOREACH are allowed as long as they do not changethe join key values in a way that would change the sort order.\n";
    private boolean firstTime = true;
    private POLocalRearrange[] LRs;
    private transient LoadFunc rightLoader;
    private OperatorKey opKey;
    private Object prevLeftKey;
    private Result prevLeftInp;
    private Object prevRightKey = null;
    private Result prevRightInp;
    private boolean doingJoin;
    private FuncSpec rightLoaderFuncSpec;
    private String rightInputFileName;
    private String indexFile;
    private transient TuplesToSchemaTupleList leftTuples;
    private MultiMap<PhysicalOperator, PhysicalPlan> inpPlans;
    private PhysicalOperator rightPipelineLeaf;
    private PhysicalOperator rightPipelineRoot;
    private boolean noInnerPlanOnRightSide;
    private Object curJoinKey;
    private Tuple curJoiningRightTup;
    private int counter;
    private int leftTupSize = -1;
    private int rightTupSize = -1;
    private int arrayListSize = 1024;
    private LOJoin.JOINTYPE joinType;
    private String signature;
    private byte endOfRecordMark = 1;
    private transient TupleFactory mTupleFactory;
    private transient TupleMaker mergedTupleMaker;
    private transient TupleMaker leftTupleMaker;
    private Schema leftInputSchema;
    private Schema mergedInputSchema;

    public POMergeJoin(OperatorKey k, int rp, List<PhysicalOperator> inp, MultiMap<PhysicalOperator, PhysicalPlan> inpPlans, List<List<Byte>> keyTypes, LOJoin.JOINTYPE joinType, Schema leftInputSchema, Schema rightInputSchema, Schema mergedInputSchema) throws PlanException {
        super(k, rp, inp);
        this.opKey = k;
        this.doingJoin = false;
        this.inpPlans = inpPlans;
        this.LRs = new POLocalRearrange[2];
        this.createJoinPlans(inpPlans, keyTypes);
        this.indexFile = null;
        this.joinType = joinType;
        this.leftInputSchema = leftInputSchema;
        this.mergedInputSchema = mergedInputSchema;
    }

    private void createJoinPlans(MultiMap<PhysicalOperator, PhysicalPlan> inpPlans, List<List<Byte>> keyTypes) throws PlanException {
        int i = -1;
        for (PhysicalOperator inpPhyOp : inpPlans.keySet()) {
            ++i;
            POLocalRearrange lr = new POLocalRearrange(this.genKey());
            try {
                lr.setIndex(i);
            }
            catch (ExecException e) {
                throw new PlanException(e.getMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
            }
            lr.setResultType((byte)110);
            lr.setKeyType(keyTypes.get(i).size() > 1 ? (byte)110 : keyTypes.get(i).get(0));
            lr.setPlans(inpPlans.get(inpPhyOp));
            this.LRs[i] = lr;
        }
    }

    private void prepareTupleFactories() {
        this.mTupleFactory = TupleFactory.getInstance();
        if (this.leftInputSchema != null) {
            this.leftTupleMaker = SchemaTupleBackend.newSchemaTupleFactory(this.leftInputSchema, false, SchemaTupleClassGenerator.GenContext.MERGE_JOIN);
        }
        if (this.leftTupleMaker == null) {
            log.debug((Object)("No SchemaTupleFactory available for combined left merge join schema: " + this.leftInputSchema));
            this.leftTupleMaker = this.mTupleFactory;
        } else {
            log.debug((Object)("Using SchemaTupleFactory for left merge join schema: " + this.leftInputSchema));
        }
        if (this.mergedInputSchema != null) {
            this.mergedTupleMaker = SchemaTupleBackend.newSchemaTupleFactory(this.mergedInputSchema, false, SchemaTupleClassGenerator.GenContext.MERGE_JOIN);
        }
        if (this.mergedTupleMaker == null) {
            log.debug((Object)("No SchemaTupleFactory available for combined left/right merge join schema: " + this.mergedInputSchema));
            this.mergedTupleMaker = this.mTupleFactory;
        } else {
            log.debug((Object)("Using SchemaTupleFactory for left/right merge join schema: " + this.mergedInputSchema));
        }
    }

    private TuplesToSchemaTupleList newLeftTupleArray() {
        return new TuplesToSchemaTupleList(this.arrayListSize, this.leftTupleMaker);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        int cmpval;
        Comparable rightKey;
        Result rightInp;
        Object curLeftKey;
        if (this.firstTime) {
            this.prepareTupleFactories();
            this.leftTuples = this.newLeftTupleArray();
            Result curLeftInp = this.processInput();
            if (curLeftInp.returnStatus != 0) {
                return curLeftInp;
            }
            Object curLeftKey2 = this.extractKeysFromTuple(curLeftInp, 0);
            if (null == curLeftKey2) {
                return new Result(this.endOfRecordMark, null);
            }
            try {
                this.seekInRightStream(curLeftKey2);
            }
            catch (IOException e) {
                this.throwProcessingException(true, e);
            }
            catch (ClassCastException e) {
                this.throwProcessingException(true, e);
            }
            this.leftTuples.add((Tuple)curLeftInp.result);
            this.firstTime = false;
            this.prevLeftKey = curLeftKey2;
            return new Result(this.endOfRecordMark, null);
        }
        if (this.doingJoin) {
            Result rightInp2;
            Object rightKey2;
            if (this.counter > 0) {
                int i;
                Tuple joiningLeftTup = this.leftTuples.get(--this.counter);
                this.leftTupSize = joiningLeftTup.size();
                Object joinedTup = this.mergedTupleMaker.newTuple(this.leftTupSize + this.rightTupSize);
                for (i = 0; i < this.leftTupSize; ++i) {
                    joinedTup.set(i, joiningLeftTup.get(i));
                }
                for (i = 0; i < this.rightTupSize; ++i) {
                    joinedTup.set(i + this.leftTupSize, this.curJoiningRightTup.get(i));
                }
                return new Result(0, joinedTup);
            }
            this.doingJoin = false;
            do {
                rightInp2 = this.getNextRightInp();
                if (rightInp2.returnStatus == 0) continue;
                this.prevRightInp = null;
                return rightInp2;
            } while (null == (rightKey2 = this.extractKeysFromTuple(rightInp2, 1)));
            int cmpval2 = ((Comparable)rightKey2).compareTo(this.curJoinKey);
            if (cmpval2 == 0) {
                this.curJoiningRightTup = (Tuple)rightInp2.result;
                this.rightTupSize = this.curJoiningRightTup.size();
                this.counter = this.leftTuples.size();
                this.doingJoin = true;
                return this.getNextTuple();
            }
            if (cmpval2 > 0) {
                if (!this.parentPlan.endOfAllInput) {
                    this.prevRightKey = rightKey2;
                    this.prevRightInp = rightInp2;
                    this.leftTuples = this.newLeftTupleArray();
                    this.leftTuples.add((Tuple)this.prevLeftInp.result);
                    return new Result(this.endOfRecordMark, null);
                }
                try {
                    ((IndexableLoadFunc)((Object)this.rightLoader)).close();
                }
                catch (IOException e) {
                    log.error((Object)("Received exception while trying to close right side file: " + e.getMessage()));
                }
                return new Result(3, null);
            }
            int errCode = 1102;
            String errMsg = "Data is not sorted on right side. \nRemember that you should not change the order of keys before a merge join in a FOREACH or manipulate join keys in a UDF in a way that would change the sort order. UDFs in a FOREACH are allowed as long as they do not changethe join key values in a way that would change the sort order.\nLast two tuples encountered were: \n" + this.curJoiningRightTup + "\n" + (Tuple)rightInp2.result;
            throw new ExecException(errMsg, errCode);
        }
        Result curLeftInp = this.processInput();
        switch (curLeftInp.returnStatus) {
            case 0: {
                curLeftKey = this.extractKeysFromTuple(curLeftInp, 0);
                if (null == curLeftKey) {
                    return new Result(this.endOfRecordMark, null);
                }
                int cmpVal = ((Comparable)curLeftKey).compareTo(this.prevLeftKey);
                if (cmpVal == 0) {
                    this.leftTuples.add((Tuple)curLeftInp.result);
                    return new Result(this.endOfRecordMark, null);
                }
                if (cmpVal > 0) {
                    this.curJoinKey = this.prevLeftKey;
                    break;
                }
                int errCode = 1102;
                String errMsg = "Data is not sorted on left side. \nRemember that you should not change the order of keys before a merge join in a FOREACH or manipulate join keys in a UDF in a way that would change the sort order. UDFs in a FOREACH are allowed as long as they do not changethe join key values in a way that would change the sort order.\nLast two tuples encountered were: \n" + this.prevLeftKey + "\n" + curLeftKey;
                throw new ExecException(errMsg, errCode);
            }
            case 3: {
                if (this.parentPlan.endOfAllInput) {
                    this.curJoinKey = this.prevLeftKey;
                    curLeftKey = null;
                    break;
                }
                return curLeftInp;
            }
            default: {
                return curLeftInp;
            }
        }
        if (null != this.prevRightKey && !this.parentPlan.endOfAllInput && ((Comparable)this.prevRightKey).compareTo(curLeftKey) >= 0) {
            this.leftTuples = this.newLeftTupleArray();
            this.leftTuples.add((Tuple)curLeftInp.result);
            this.prevLeftInp = curLeftInp;
            this.prevLeftKey = curLeftKey;
            return new Result(this.endOfRecordMark, null);
        }
        if (null != this.prevRightKey && this.prevRightKey.equals(this.prevLeftKey)) {
            this.curJoiningRightTup = (Tuple)this.prevRightInp.result;
            this.counter = this.leftTuples.size();
            this.rightTupSize = this.curJoiningRightTup.size();
            this.doingJoin = true;
            this.prevLeftInp = curLeftInp;
            this.prevLeftKey = curLeftKey;
            return this.getNextTuple();
        }
        boolean slidingToNextRecord = false;
        while (true) {
            if (slidingToNextRecord) {
                rightInp = this.getNextRightInp();
                slidingToNextRecord = false;
            } else {
                rightInp = this.getNextRightInp(this.prevLeftKey);
            }
            if (rightInp.returnStatus != 0) {
                return rightInp;
            }
            Object extractedRightKey = this.extractKeysFromTuple(rightInp, 1);
            if (null == extractedRightKey) continue;
            rightKey = (Comparable)extractedRightKey;
            if (this.prevRightKey != null && rightKey.compareTo(this.prevRightKey) < 0) {
                int errCode = 1102;
                String errMsg = "Data is not sorted on right side. \nRemember that you should not change the order of keys before a merge join in a FOREACH or manipulate join keys in a UDF in a way that would change the sort order. UDFs in a FOREACH are allowed as long as they do not changethe join key values in a way that would change the sort order.\nLast two tuples encountered were: \n" + this.prevRightKey + "\n" + rightKey;
                throw new ExecException(errMsg, errCode);
            }
            cmpval = rightKey.compareTo(this.prevLeftKey);
            if (cmpval >= 0) break;
            slidingToNextRecord = true;
        }
        if (cmpval == 0) {
            this.curJoiningRightTup = (Tuple)rightInp.result;
            this.counter = this.leftTuples.size();
            this.rightTupSize = this.curJoiningRightTup.size();
            this.doingJoin = true;
            this.prevLeftInp = curLeftInp;
            this.prevLeftKey = curLeftKey;
            return this.getNextTuple();
        }
        this.prevRightKey = rightKey;
        this.prevRightInp = rightInp;
        this.leftTuples = this.newLeftTupleArray();
        this.leftTuples.add((Tuple)curLeftInp.result);
        this.prevLeftInp = curLeftInp;
        this.prevLeftKey = curLeftKey;
        if (this.parentPlan.endOfAllInput) {
            try {
                ((IndexableLoadFunc)((Object)this.rightLoader)).close();
            }
            catch (IOException e) {
                log.error((Object)("Received exception while trying to close right side file: " + e.getMessage()));
            }
        }
        return new Result(this.endOfRecordMark, null);
    }

    private void seekInRightStream(Object firstLeftKey) throws IOException {
        this.rightLoader = (LoadFunc)PigContext.instantiateFuncFromSpec(this.rightLoaderFuncSpec);
        if (this.indexFile != null && this.rightLoader instanceof DefaultIndexableLoader) {
            DefaultIndexableLoader loader = (DefaultIndexableLoader)this.rightLoader;
            loader.setIndexFile(this.indexFile);
        }
        this.rightLoader.setUDFContextSignature(this.signature);
        Job job = new Job(new Configuration((Configuration)PigMapReduce.sJobConfInternal.get()));
        this.rightLoader.setLocation(this.rightInputFileName, job);
        ((IndexableLoadFunc)((Object)this.rightLoader)).initialize(job.getConfiguration());
        ((IndexableLoadFunc)((Object)this.rightLoader)).seekNear(firstLeftKey instanceof Tuple ? (Tuple)firstLeftKey : this.mTupleFactory.newTuple(firstLeftKey));
    }

    private Result getNextRightInp(Object leftKey) throws ExecException {
        if (this.joinType == LOJoin.JOINTYPE.MERGESPARSE) {
            try {
                ((IndexableLoadFunc)((Object)this.rightLoader)).seekNear(leftKey instanceof Tuple ? (Tuple)leftKey : this.mTupleFactory.newTuple(leftKey));
                this.prevRightKey = null;
            }
            catch (IOException e) {
                this.throwProcessingException(true, e);
            }
        }
        return this.getNextRightInp();
    }

    private Result getNextRightInp() throws ExecException {
        try {
            if (this.noInnerPlanOnRightSide) {
                Tuple t = this.rightLoader.getNext();
                if (t == null) {
                    return new Result(3, null);
                }
                return new Result(0, t);
            }
            Result res = this.rightPipelineLeaf.getNextTuple();
            this.rightPipelineLeaf.detachInput();
            switch (res.returnStatus) {
                case 0: {
                    return res;
                }
                case 3: {
                    Tuple t = this.rightLoader.getNext();
                    if (t == null) {
                        return new Result(3, null);
                    }
                    this.rightPipelineRoot.attachInput(t);
                    return this.getNextRightInp();
                }
            }
            this.throwProcessingException(false, null);
        }
        catch (IOException e) {
            this.throwProcessingException(true, e);
        }
        return new Result(2, null);
    }

    public void throwProcessingException(boolean withCauseException, Exception e) throws ExecException {
        int errCode = 2176;
        String errMsg = "Error processing right input during merge join";
        if (withCauseException) {
            throw new ExecException(errMsg, errCode, 4, e);
        }
        throw new ExecException(errMsg, errCode, 4);
    }

    private Object extractKeysFromTuple(Result inp, int lrIdx) throws ExecException {
        POLocalRearrange lr = this.LRs[lrIdx];
        lr.attachInput((Tuple)inp.result);
        Result lrOut = lr.getNextTuple();
        lr.detachInput();
        if (lrOut.returnStatus != 0) {
            int errCode = 2167;
            String errMsg = "LocalRearrange used to extract keys from tuple isn't configured correctly";
            throw new ExecException(errMsg, errCode, 4);
        }
        return ((Tuple)lrOut.result).get(1);
    }

    public void setupRightPipeline(PhysicalPlan rightPipeline) throws FrontendException {
        if (rightPipeline != null) {
            if (rightPipeline.getLeaves().size() != 1 || rightPipeline.getRoots().size() != 1) {
                int errCode = 2168;
                String errMsg = "Expected physical plan with exactly one root and one leaf.";
                throw new FrontendException(errMsg, errCode, 4);
            }
            this.noInnerPlanOnRightSide = false;
            this.rightPipelineLeaf = (PhysicalOperator)rightPipeline.getLeaves().get(0);
            this.rightPipelineRoot = (PhysicalOperator)rightPipeline.getRoots().get(0);
            this.rightPipelineRoot.setInputs(null);
        } else {
            this.noInnerPlanOnRightSide = true;
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, ExecException {
        is.defaultReadObject();
        this.mTupleFactory = TupleFactory.getInstance();
    }

    private OperatorKey genKey() {
        return new OperatorKey(this.opKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.opKey.scope));
    }

    public void setRightLoaderFuncSpec(FuncSpec rightLoaderFuncSpec) {
        this.rightLoaderFuncSpec = rightLoaderFuncSpec;
    }

    public List<PhysicalPlan> getInnerPlansOf(int index) {
        return this.inpPlans.get((PhysicalOperator)this.inputs.get(index));
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMergeJoin(this);
    }

    @Override
    public String name() {
        String name = this.getAliasString() + "MergeJoin";
        if (this.joinType == LOJoin.JOINTYPE.MERGESPARSE) {
            name = name + "(sparse)";
        }
        name = name + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
        return name;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void setRightInputFileName(String rightInputFileName) {
        this.rightInputFileName = rightInputFileName;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    public LOJoin.JOINTYPE getJoinType() {
        return this.joinType;
    }

    public static class TuplesToSchemaTupleList
    extends ArrayList<Tuple> {
        private SchemaTupleFactory tf;

        public TuplesToSchemaTupleList(int ct, TupleMaker<?> tf) {
            super(ct);
            if (tf instanceof SchemaTupleFactory) {
                this.tf = (SchemaTupleFactory)tf;
            }
        }

        public static SchemaTuple<?> convert(Tuple t, SchemaTupleFactory tf) {
            if (t instanceof SchemaTuple) {
                return (SchemaTuple)t;
            }
            Tuple st = tf.newTuple();
            try {
                return ((SchemaTuple)st).set(t);
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to set SchemaTuple with schema [" + ((SchemaTuple)st).getSchemaString() + "] with given Tuple in merge join.");
            }
        }

        @Override
        public boolean add(Tuple t) {
            if (this.tf != null) {
                t = TuplesToSchemaTupleList.convert(t, this.tf);
            }
            return super.add(t);
        }

        @Override
        public Tuple get(int i) {
            return (Tuple)super.get(i);
        }

        @Override
        public int size() {
            return super.size();
        }
    }
}

