/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop20;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.jobcontrol.JobControl;

public class PigJobControl
extends JobControl {
    private static final Log log = LogFactory.getLog(PigJobControl.class);
    private static Field runnerState;
    private static Method checkRunningJobs;
    private static Method checkWaitingJobs;
    private static Method startReadyJobs;
    private static boolean initSuccesful;
    private static final int RUNNING = 0;
    private static final int SUSPENDED = 1;
    private static final int STOPPED = 2;
    private static final int STOPPING = 3;
    private static final int READY = 4;
    private int timeToSleep;

    public PigJobControl(String groupName, int timeToSleep) {
        super(groupName);
        this.timeToSleep = timeToSleep;
    }

    public int getTimeToSleep() {
        return this.timeToSleep;
    }

    public void setTimeToSleep(int timeToSleep) {
        this.timeToSleep = timeToSleep;
    }

    private void setRunnerState(int state) {
        try {
            runnerState.set((Object)this, state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getRunnerState() {
        try {
            return (Integer)runnerState.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        if (!initSuccesful) {
            super.run();
            return;
        }
        this.setRunnerState(0);
        while (true) {
            if (this.getRunnerState() == 1) {
                try {
                    Thread.sleep(this.timeToSleep);
                }
                catch (Exception e) {}
                continue;
            }
            this.mainLoopAction();
            if (this.getRunnerState() != 0 && this.getRunnerState() != 1) break;
            try {
                Thread.sleep(this.timeToSleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getRunnerState() != 0 && this.getRunnerState() != 1) break;
        }
        this.setRunnerState(2);
    }

    private void mainLoopAction() {
        try {
            checkRunningJobs.invoke((Object)this, new Object[0]);
            checkWaitingJobs.invoke((Object)this, new Object[0]);
            startReadyJobs.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            runnerState = JobControl.class.getDeclaredField("runnerState");
            runnerState.setAccessible(true);
            checkRunningJobs = JobControl.class.getDeclaredMethod("checkRunningJobs", new Class[0]);
            checkRunningJobs.setAccessible(true);
            checkWaitingJobs = JobControl.class.getDeclaredMethod("checkWaitingJobs", new Class[0]);
            checkWaitingJobs.setAccessible(true);
            startReadyJobs = JobControl.class.getDeclaredMethod("startReadyJobs", new Class[0]);
            startReadyJobs.setAccessible(true);
            initSuccesful = true;
        }
        catch (Exception e) {
            log.warn((Object)"falling back to default JobControl (not using hadoop 0.20 ?)", (Throwable)e);
            initSuccesful = false;
        }
    }
}

