/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableSnapshotScanner
extends AbstractClientScanner {
    private static final Log LOG = LogFactory.getLog(TableSnapshotScanner.class);
    private Configuration conf;
    private String snapshotName;
    private FileSystem fs;
    private Path rootDir;
    private Path restoreDir;
    private Scan scan;
    private ArrayList<HRegionInfo> regions;
    private HTableDescriptor htd;
    private ClientSideRegionScanner currentRegionScanner = null;
    private int currentRegion = -1;

    public TableSnapshotScanner(Configuration conf, Path restoreDir, String snapshotName, Scan scan) throws IOException {
        this(conf, FSUtils.getRootDir(conf), restoreDir, snapshotName, scan);
    }

    public TableSnapshotScanner(Configuration conf, Path rootDir, Path restoreDir, String snapshotName, Scan scan) throws IOException {
        this.conf = conf;
        this.snapshotName = snapshotName;
        this.rootDir = rootDir;
        this.restoreDir = new Path(restoreDir, UUID.randomUUID().toString());
        this.scan = scan;
        this.fs = rootDir.getFileSystem(conf);
        this.init();
    }

    private void init() throws IOException {
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshotName, this.rootDir);
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, snapshotDesc);
        this.htd = manifest.getTableDescriptor();
        List<SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifests();
        if (regionManifests == null) {
            throw new IllegalArgumentException("Snapshot seems empty");
        }
        this.regions = new ArrayList(regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionManifest.getRegionInfo());
            if (!CellUtil.overlappingKeys((byte[])this.scan.getStartRow(), (byte[])this.scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey())) continue;
            this.regions.add(hri);
        }
        Collections.sort(this.regions);
        this.initScanMetrics(this.scan);
        RestoreSnapshotHelper.copySnapshotForScanner(this.conf, this.fs, this.rootDir, this.restoreDir, this.snapshotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result next() throws IOException {
        Result result = null;
        while (true) {
            if (this.currentRegionScanner == null) {
                ++this.currentRegion;
                if (this.currentRegion >= this.regions.size()) {
                    return null;
                }
                HRegionInfo hri = this.regions.get(this.currentRegion);
                this.currentRegionScanner = new ClientSideRegionScanner(this.conf, this.fs, this.restoreDir, this.htd, hri, this.scan, this.scanMetrics);
                if (this.scanMetrics != null) {
                    this.scanMetrics.countOfRegions.incrementAndGet();
                }
            }
            try {
                result = this.currentRegionScanner.next();
                if (result == null) continue;
                Result result2 = result;
                return result2;
            }
            finally {
                if (result != null) continue;
                this.currentRegionScanner.close();
                this.currentRegionScanner = null;
                continue;
            }
            break;
        }
    }

    public void close() {
        if (this.currentRegionScanner != null) {
            this.currentRegionScanner.close();
        }
        try {
            this.fs.delete(this.restoreDir, true);
        }
        catch (IOException ex) {
            LOG.warn((Object)("Could not delete restore directory for the snapshot:" + ex));
        }
    }
}

