/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.MultiHConnection;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionStateStore {
    private static final Log LOG = LogFactory.getLog(RegionStateStore.class);
    private volatile HRegion metaRegion;
    private volatile HRegion rootRegion;
    private volatile boolean initialized;
    private final boolean noPersistence;
    private final CatalogTracker catalogTracker;
    private final Server server;
    private MultiHConnection multiHConnection;

    static ServerName getRegionServer(Result r) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVERNAME_QUALIFIER);
        if (cell == null || cell.getValueLength() == 0) {
            return HRegionInfo.getServerName((Result)r);
        }
        return ServerName.parseServerName((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    static RegionState.State getRegionState(Result r) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER);
        if (cell == null || cell.getValueLength() == 0) {
            return RegionState.State.OPEN;
        }
        return RegionState.State.valueOf((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private boolean shouldPersistStateChange(HRegionInfo hri, RegionState state, RegionState oldState) {
        return !hri.isMetaRegion() && !RegionStates.isOneOfStates(state, RegionState.State.MERGING_NEW, RegionState.State.SPLITTING_NEW, RegionState.State.MERGED) && (!RegionStates.isOneOfStates(state, RegionState.State.OFFLINE) || !RegionStates.isOneOfStates(oldState, RegionState.State.MERGING_NEW, RegionState.State.SPLITTING_NEW, RegionState.State.MERGED));
    }

    RegionStateStore(Server server) {
        Configuration conf = server.getConfiguration();
        this.noPersistence = ConfigUtil.useZKForAssignment(conf) && !conf.getBoolean("hbase.assignment.usezk.migrating", false);
        this.catalogTracker = server.getCatalogTracker();
        this.server = server;
        this.initialized = false;
    }

    void start() throws IOException {
        if (!this.noPersistence) {
            if (this.server instanceof RegionServerServices) {
                this.metaRegion = ((RegionServerServices)this.server).getFromOnlineRegions(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
            }
            if (this.metaRegion == null) {
                Configuration conf = this.server.getConfiguration();
                this.multiHConnection = new MultiHConnection(conf, conf.getInt("hbase.regionstatestore.meta.connection", 1));
            }
        }
        this.initialized = true;
    }

    void stop() {
        this.initialized = false;
        if (this.multiHConnection != null) {
            this.multiHConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegionState(long openSeqNum, RegionState newState, RegionState oldState) {
        if (this.noPersistence) {
            return;
        }
        try {
            HRegionInfo hri = newState.getRegion();
            if (hri.isMetaRegion()) {
                try {
                    MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.server.getZooKeeper(), (ServerName)newState.getServerName(), (RegionState.State)newState.getState());
                    return;
                }
                catch (KeeperException e) {
                    throw new IOException("Failed to update meta ZNode", e);
                }
            }
            if (!this.initialized || !this.shouldPersistStateChange(hri, newState, oldState)) {
                return;
            }
            ServerName oldServer = oldState != null ? oldState.getServerName() : null;
            ServerName serverName = newState.getServerName();
            RegionState.State state = newState.getState();
            Put put = new Put(hri.getRegionName());
            StringBuilder info = new StringBuilder("Updating row ");
            info.append(hri.getRegionNameAsString()).append(" with state=").append(state);
            if (serverName != null && !serverName.equals((Object)oldServer)) {
                put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVERNAME_QUALIFIER, Bytes.toBytes((String)serverName.getServerName()));
                info.append("&sn=").append(serverName);
            }
            if (openSeqNum >= 0L) {
                Preconditions.checkArgument((state == RegionState.State.OPEN && serverName != null ? 1 : 0) != 0, (Object)"Open region should be on a server");
                put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)serverName.getHostAndPort()));
                put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)serverName.getStartcode()));
                put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes((long)openSeqNum));
                info.append("&openSeqNum=").append(openSeqNum);
                info.append("&server=").append(serverName);
            }
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)state.name()));
            LOG.info((Object)info);
            if (this.metaRegion != null) {
                try {
                    this.metaRegion.put(put);
                    return;
                }
                catch (Throwable t) {
                    RegionStateStore regionStateStore = this;
                    synchronized (regionStateStore) {
                        if (this.metaRegion != null) {
                            LOG.info((Object)"Meta region shortcut failed", t);
                            if (this.multiHConnection == null) {
                                this.multiHConnection = new MultiHConnection(this.server.getConfiguration(), 1);
                            }
                            this.metaRegion = null;
                        }
                    }
                }
            }
            this.multiHConnection.processBatchCallback(Arrays.asList(put), TableName.META_TABLE_NAME, null, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Failed to persist region state " + newState), (Throwable)ioe);
            this.server.abort("Failed to update region location", (Throwable)ioe);
        }
    }

    void splitRegion(HRegionInfo p, HRegionInfo a, HRegionInfo b, ServerName sn) throws IOException {
        MetaEditor.splitRegion(this.catalogTracker, p, a, b, sn);
    }

    void mergeRegions(HRegionInfo p, HRegionInfo a, HRegionInfo b, ServerName sn) throws IOException {
        MetaEditor.mergeRegions(this.catalogTracker, p, a, b, sn);
    }
}

