/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;

public class ParsedRecord
implements Writable {
    private final Map<String, String> stringValues = new HashMap<String, String>();
    private final Map<String, Long> longValues = new HashMap<String, Long>();
    private final Map<String, Double> doubleValues = new HashMap<String, Double>();
    private final Map<String, Map<String, String>> stringSetValues = new HashMap<String, Map<String, String>>();
    private final Map<String, String> stringSetPrefixes = new HashMap<String, String>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsedRecord)) {
            return false;
        }
        ParsedRecord that = (ParsedRecord)o;
        if (!this.doubleValues.equals(that.doubleValues)) {
            return false;
        }
        if (!this.longValues.equals(that.longValues)) {
            return false;
        }
        if (!this.stringSetValues.equals(that.stringSetValues)) {
            return false;
        }
        return this.stringValues.equals(that.stringValues);
    }

    public int hashCode() {
        int result = this.stringValues.hashCode();
        result = 31 * result + this.longValues.hashCode();
        result = 31 * result + this.doubleValues.hashCode();
        result = 31 * result + this.stringSetValues.hashCode();
        return result;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.stringValues.size());
        for (Map.Entry<String, String> entry : this.stringValues.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
        out.writeInt(this.longValues.size());
        for (Map.Entry<String, Object> entry : this.longValues.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        out.writeInt(this.doubleValues.size());
        for (Map.Entry<String, Object> entry : this.doubleValues.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeDouble((Double)entry.getValue());
        }
        out.writeInt(this.stringSetValues.size());
        for (Map.Entry<String, Object> entry : this.stringSetValues.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(((Map)entry.getValue()).size());
            for (Map.Entry s : ((Map)entry.getValue()).entrySet()) {
                out.writeUTF((String)s.getKey());
                out.writeUTF((String)s.getValue());
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        int count;
        int nrOfValues = in.readInt();
        for (count = 0; count < nrOfValues; ++count) {
            this.set(in.readUTF(), in.readUTF());
        }
        nrOfValues = in.readInt();
        for (count = 0; count < nrOfValues; ++count) {
            this.set(in.readUTF(), in.readLong());
        }
        nrOfValues = in.readInt();
        for (count = 0; count < nrOfValues; ++count) {
            this.set(in.readUTF(), in.readDouble());
        }
        int nrOfFields = in.readInt();
        for (int fieldNr = 0; fieldNr < nrOfFields; ++fieldNr) {
            String fieldName = in.readUTF();
            this.declareRequestedFieldname(fieldName);
            nrOfValues = in.readInt();
            for (int valueNr = 0; valueNr < nrOfValues; ++valueNr) {
                String key = in.readUTF();
                String value = in.readUTF();
                this.setMultiValueString(key, value);
            }
        }
    }

    public void clear() {
        this.stringValues.clear();
        this.longValues.clear();
        this.doubleValues.clear();
        for (Map.Entry<String, Map<String, String>> stringMap : this.stringSetValues.entrySet()) {
            stringMap.getValue().clear();
        }
    }

    public void set(String name, String value) {
        if (value != null) {
            this.stringValues.put(name, value);
        }
    }

    public void set(String name, Long value) {
        if (value != null) {
            this.longValues.put(name, value);
        }
    }

    public void set(String name, Double value) {
        if (value != null) {
            this.doubleValues.put(name, value);
        }
    }

    public void declareRequestedFieldname(String name) {
        if (name.endsWith(".*")) {
            this.stringSetValues.put(name, new HashMap());
            this.stringSetPrefixes.put(name.substring(0, name.length() - 1), name);
        }
    }

    public void setMultiValueString(String name, String value) {
        if (value != null) {
            for (Map.Entry<String, String> stringSetPrefix : this.stringSetPrefixes.entrySet()) {
                String prefix = stringSetPrefix.getKey();
                if (!name.startsWith(prefix)) continue;
                this.stringSetValues.get(stringSetPrefix.getValue()).put(name.substring(prefix.length()), value);
            }
        }
    }

    public String getString(String name) {
        return this.stringValues.get(name);
    }

    public Long getLong(String name) {
        return this.longValues.get(name);
    }

    public Double getDouble(String name) {
        return this.doubleValues.get(name);
    }

    public Map<String, String> getStringSet(String name) {
        return this.stringSetValues.get(name);
    }
}

