/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.MetaData;
import org.apache.trevni.avro.AvroColumnWriter;

public class AvroTrevniOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    public static final String EXT = ".trv";
    public static final String META_PREFIX = "trevni.meta.";

    public static void setMeta(JobConf job, String key, String value) {
        job.set(META_PREFIX + key, value);
    }

    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(FileSystem ignore, JobConf job, String name, Progressable prog) throws IOException {
        boolean isMapOnly = job.getNumReduceTasks() == 0;
        final Schema schema = isMapOnly ? AvroJob.getMapOutputSchema((Configuration)job) : AvroJob.getOutputSchema((Configuration)job);
        final ColumnFileMetaData meta = AvroTrevniOutputFormat.filterMetadata(job);
        final Path dir = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)name);
        final FileSystem fs = dir.getFileSystem((Configuration)job);
        if (!fs.mkdirs(dir)) {
            throw new IOException("Failed to create directory: " + dir);
        }
        final long blockSize = fs.getDefaultBlockSize();
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){
            private int part = 0;
            private AvroColumnWriter<T> writer = new AvroColumnWriter(schema, meta, (GenericData)ReflectData.get());

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void flush() throws IOException {
                FSDataOutputStream out = fs.create(new Path(dir, "part-" + this.part++ + AvroTrevniOutputFormat.EXT));
                try {
                    this.writer.writeTo((OutputStream)out);
                }
                finally {
                    out.close();
                }
                this.writer = new AvroColumnWriter(schema, meta, (GenericData)ReflectData.get());
            }

            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                this.writer.write(wrapper.datum());
                if (this.writer.sizeEstimate() >= blockSize) {
                    this.flush();
                }
            }

            public void close(Reporter reporter) throws IOException {
                this.flush();
            }
        };
    }

    static ColumnFileMetaData filterMetadata(JobConf job) {
        ColumnFileMetaData meta = new ColumnFileMetaData();
        for (Map.Entry e : job) {
            if (!((String)e.getKey()).startsWith(META_PREFIX)) continue;
            meta.put((Object)((String)e.getKey()).substring(META_PREFIX.length()), (Object)((String)e.getValue()).getBytes(MetaData.UTF8));
        }
        return meta;
    }
}

