/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class LongComparator
extends ByteArrayComparable {
    private Long longValue;

    public LongComparator(long value) {
        super(Bytes.toBytes((long)value));
        this.longValue = value;
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        Long that = Bytes.toLong((byte[])value, (int)offset, (int)length);
        return this.longValue.compareTo(that);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.LongComparator.Builder builder = ComparatorProtos.LongComparator.newBuilder();
        builder.setComparable(super.convert());
        return builder.build().toByteArray();
    }

    public static LongComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.LongComparator proto;
        try {
            proto = ComparatorProtos.LongComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new LongComparator(Bytes.toLong((byte[])proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(LongComparator other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LongComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

