/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;

public class MetricsReplicationGlobalSourceSource
implements MetricsReplicationSourceSource {
    private final MetricMutableGaugeLong ageOfLastShippedOpGauge;
    private long ageOfLastShipped;
    private final MetricMutableGaugeLong sizeOfLogQueueGauge;
    private final MetricMutableCounterLong logReadInEditsCounter;
    private final MetricMutableCounterLong logEditsFilteredCounter;
    private final MetricMutableCounterLong shippedBatchesCounter;
    private final MetricMutableCounterLong shippedOpsCounter;
    private final MetricMutableCounterLong shippedKBsCounter;
    private final MetricMutableCounterLong logReadInBytesCounter;

    public MetricsReplicationGlobalSourceSource(MetricsReplicationSourceImpl rms) {
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge("source.ageOfLastShippedOp", 0L);
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge("source.sizeOfLogQueue", 0L);
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter("source.shippedBatches", 0L);
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedOps", 0L);
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedKBs", 0L);
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter("source.logReadInBytes", 0L);
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsRead", 0L);
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsFiltered", 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
        this.ageOfLastShipped = age;
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr((long)batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
    }

    public long getLastShippedAge() {
        return this.ageOfLastShipped;
    }
}

