/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tutorial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.tutorial.TutorialUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGramGenerator
extends EvalFunc<DataBag> {
    private static final int _ngramSizeLimit = 2;

    public DataBag exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() == 0) {
            return null;
        }
        try {
            DataBag dataBag = DefaultBagFactory.getInstance().newDefaultBag();
            String string = (String)tuple.get(0);
            String[] stringArray = TutorialUtil.splitToWords(string);
            HashSet<String> hashSet = new HashSet<String>();
            TutorialUtil.makeNGram(stringArray, hashSet, 2);
            for (String string2 : hashSet) {
                Tuple tuple2 = TupleFactory.getInstance().newTuple(1);
                tuple2.set(0, (Object)string2);
                dataBag.add(tuple2);
            }
            return dataBag;
        }
        catch (Exception exception) {
            System.err.println("NGramGenerator: failed to process input; error - " + exception.getMessage());
            return null;
        }
    }

    public Schema outputSchema(Schema schema) {
        Schema schema2 = new Schema();
        schema2.add(new Schema.FieldSchema("ngram", 55));
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), schema), schema2, 120));
        }
        catch (FrontendException frontendException) {
            return null;
        }
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> arrayList = new ArrayList<FuncSpec>();
        arrayList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 55))));
        return arrayList;
    }
}

