/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.util.Utils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SortColInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String colName;
    private int colIndex;
    private Order sortOrder;

    public SortColInfo(String colName, int colIndex, Order orderingType) {
        this.colName = colName;
        this.colIndex = colIndex;
        this.sortOrder = orderingType;
    }

    public String getColName() {
        return this.colName;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public Order getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colName == null ? 0 : this.colName.hashCode());
        result = 31 * result + this.colIndex;
        result = 31 * result + (this.sortOrder == Order.ASCENDING ? 1 : 2);
        return result;
    }

    public boolean equals(Object obj) {
        if (!Utils.checkNullAndClass(this, obj)) {
            return false;
        }
        SortColInfo other = (SortColInfo)obj;
        return Utils.checkNullEquals(this.colName, other.colName, true) && this.colIndex == other.colIndex && this.sortOrder == other.sortOrder;
    }

    public String toString() {
        return "colname:" + this.colName + ",colindex:" + this.colIndex + ",orderingType:" + (this.sortOrder == Order.ASCENDING ? "ascending" : "descending");
    }

    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

