/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.datastorage.HDirectory;
import org.apache.pig.backend.hadoop.datastorage.HFile;
import org.apache.pig.backend.hadoop.datastorage.HPath;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.util.LRUMap;

public class JsonMetadata
implements LoadMetadata,
StoreMetadata {
    private static final Log log = LogFactory.getLog(JsonMetadata.class);
    private final String schemaFileName;
    private final String headerFileName;
    private final String statFileName;
    private boolean printHeaders = true;
    private byte fieldDel;
    private byte recordDel;
    private transient LRUMap<ElementDescriptor, Boolean> lookupCache = new LRUMap(100, 1000);

    public JsonMetadata() {
        this(".pig_schema", ".pig_header", ".pig_stats");
    }

    public JsonMetadata(String schemaFileName, String headerFileName, String statFileName) {
        this.schemaFileName = schemaFileName;
        this.headerFileName = headerFileName;
        this.statFileName = statFileName;
    }

    protected Set<ElementDescriptor> findMetaFile(String path, String metaname, Configuration conf) throws IOException {
        String[] locations;
        HashSet<ElementDescriptor> metaFileSet = new HashSet<ElementDescriptor>();
        for (String loc : locations = LoadFunc.getPathStrings(path)) {
            ElementDescriptor[] descriptors;
            String fullPath;
            HDataStorage storage = new HDataStorage(new Path(loc).toUri(), ConfigurationUtil.toProperties(conf));
            if (storage.isContainer(fullPath = FileLocalizer.fullPath(loc, storage))) {
                ElementDescriptor metaFilePath = storage.asElement(fullPath, metaname);
                if (!this.exists(metaFilePath)) continue;
                metaFileSet.add(metaFilePath);
                continue;
            }
            for (ElementDescriptor descriptor : descriptors = storage.asCollection(loc)) {
                HDirectory container = null;
                if (descriptor instanceof HFile) {
                    Path descriptorPath = ((HPath)descriptor).getPath();
                    Path parent = descriptorPath.getParent();
                    container = new HDirectory(storage, parent);
                } else {
                    container = (HDirectory)descriptor;
                }
                ElementDescriptor metaFilePath = storage.asElement((ContainerDescriptor)container, metaname);
                if (!this.exists(metaFilePath)) continue;
                metaFileSet.add(metaFilePath);
            }
        }
        return metaFileSet;
    }

    private boolean exists(ElementDescriptor e) throws IOException {
        if (this.lookupCache.containsKey(e)) {
            return (Boolean)this.lookupCache.get(e);
        }
        boolean res = e.exists();
        this.lookupCache.put(e, res);
        return res;
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        return this.getSchema(location, job, false);
    }

    public ResourceSchema getSchema(String location, Job job, boolean isSchemaOn) throws IOException {
        Configuration conf = job.getConfiguration();
        Set<ElementDescriptor> schemaFileSet = null;
        try {
            schemaFileSet = this.findMetaFile(location, this.schemaFileName, conf);
        }
        catch (IOException e) {
            String msg = "Could not find schema file for " + location;
            return this.nullOrException(isSchemaOn, msg, e);
        }
        ElementDescriptor schemaFile = null;
        if (schemaFileSet.isEmpty()) {
            String msg = "Could not find schema file for " + location;
            return this.nullOrException(isSchemaOn, msg, null);
        }
        schemaFile = schemaFileSet.iterator().next();
        log.debug((Object)("Found schema file: " + schemaFile.toString()));
        ResourceSchema resourceSchema = null;
        try {
            resourceSchema = new ObjectMapper().readValue(schemaFile.open(), ResourceSchema.class);
        }
        catch (JsonParseException e) {
            String msg = "Unable to load Resource Schema for " + location;
            return this.nullOrException(isSchemaOn, msg, e);
        }
        catch (JsonMappingException e) {
            String msg = "Unable to load Resource Schema for " + location;
            return this.nullOrException(isSchemaOn, msg, e);
        }
        catch (IOException e) {
            String msg = "Unable to load Resource Schema for " + location;
            return this.nullOrException(isSchemaOn, msg, e);
        }
        return resourceSchema;
    }

    private ResourceSchema nullOrException(boolean isSchemaOn, String msg, IOException e) throws FrontendException {
        if (isSchemaOn) {
            throw new FrontendException(msg, 1131, 2, (Throwable)e);
        }
        log.debug((Object)msg);
        return null;
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        Set<ElementDescriptor> statFileSet = null;
        try {
            statFileSet = this.findMetaFile(location, this.statFileName, conf);
        }
        catch (IOException e) {
            log.warn((Object)("could not fine stat file for " + location));
            return null;
        }
        ElementDescriptor statFile = null;
        if (statFileSet.isEmpty()) {
            log.warn((Object)("Could not find stat file for " + location));
            return null;
        }
        statFile = statFileSet.iterator().next();
        log.debug((Object)("Found stat file " + statFile.toString()));
        ResourceStatistics resourceStats = null;
        try {
            resourceStats = new ObjectMapper().readValue(statFile.open(), ResourceStatistics.class);
        }
        catch (JsonParseException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        return resourceStats;
    }

    @Override
    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        HDataStorage storage = new HDataStorage(new Path(location).toUri(), ConfigurationUtil.toProperties(conf));
        ElementDescriptor statFilePath = storage.asElement(location, this.statFileName);
        if (!statFilePath.exists() && stats != null) {
            try {
                new ObjectMapper().writeValue(statFilePath.create(), (Object)stats);
            }
            catch (JsonGenerationException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        ElementDescriptor headerFilePath;
        Configuration conf = job.getConfiguration();
        HDataStorage storage = new HDataStorage(new Path(location).toUri(), ConfigurationUtil.toProperties(conf));
        ElementDescriptor schemaFilePath = storage.asElement(location, this.schemaFileName);
        if (!schemaFilePath.exists() && schema != null) {
            try {
                new ObjectMapper().writeValue(schemaFilePath.create(), (Object)schema);
            }
            catch (JsonGenerationException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
        }
        if (this.printHeaders && !(headerFilePath = storage.asElement(location, this.headerFileName)).exists()) {
            try (OutputStream os = headerFilePath.create();){
                String[] names = schema.fieldNames();
                for (int i = 0; i < names.length; ++i) {
                    String fn = names[i] == null ? "$" + i : names[i];
                    os.write(fn.getBytes("UTF-8"));
                    if (i < names.length - 1) {
                        os.write(this.fieldDel);
                        continue;
                    }
                    os.write(this.recordDel);
                }
            }
        }
    }

    public void setFieldDel(byte fieldDel) {
        this.fieldDel = fieldDel;
    }

    public void setRecordDel(byte recordDel) {
        this.recordDel = recordDel;
    }
}

