/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.MetadataLocationObtainer;
import org.apache.accumulo.core.client.impl.RootTabletLocator;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public abstract class TabletLocator {
    private static HashMap<LocatorKey, TabletLocator> locators = new HashMap();
    private static final Text ROOT_TABLET_MDE = KeyExtent.getMetadataEntry(new Text("!0"), null);

    public abstract TabletLocation locateTablet(Text var1, boolean var2, boolean var3, TCredentials var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract void binMutations(List<Mutation> var1, Map<String, TabletServerMutations> var2, List<Mutation> var3, TCredentials var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract List<Range> binRanges(List<Range> var1, Map<String, Map<KeyExtent, List<Range>>> var2, TCredentials var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract void invalidateCache(KeyExtent var1);

    public abstract void invalidateCache(Collection<KeyExtent> var1);

    public abstract void invalidateCache();

    public abstract void invalidateCache(String var1);

    public static synchronized TabletLocator getInstance(Instance instance, Text tableId) {
        LocatorKey key = new LocatorKey(instance.getInstanceID(), tableId);
        TabletLocator tl = locators.get(key);
        if (tl == null) {
            MetadataLocationObtainer mlo = new MetadataLocationObtainer(instance);
            if (tableId.toString().equals("!0")) {
                RootTabletLocator rootTabletLocator = new RootTabletLocator(instance);
                tl = new TabletLocatorImpl(new Text("!0"), rootTabletLocator, mlo){

                    @Override
                    public TabletLocation _locateTablet(Text row, boolean skipRow, boolean retry, boolean lock, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
                        int comparison_result = row.compareTo((BinaryComparable)ROOT_TABLET_MDE);
                        if (skipRow && comparison_result < 0 || !skipRow && comparison_result <= 0) {
                            return this.parent.locateTablet(row, skipRow, retry, credentials);
                        }
                        return super._locateTablet(row, skipRow, retry, lock, credentials);
                    }
                };
            } else {
                TabletLocator rootTabletCache = TabletLocator.getInstance(instance, new Text("!0"));
                tl = new TabletLocatorImpl(tableId, rootTabletCache, mlo);
            }
            locators.put(key, tl);
        }
        return tl;
    }

    public static class TabletServerMutations {
        private Map<KeyExtent, List<Mutation>> mutations = new HashMap<KeyExtent, List<Mutation>>();

        public void addMutation(KeyExtent ke, Mutation m) {
            List<Mutation> mutList = this.mutations.get(ke);
            if (mutList == null) {
                mutList = new ArrayList<Mutation>();
                this.mutations.put(ke, mutList);
            }
            mutList.add(m);
        }

        public Map<KeyExtent, List<Mutation>> getMutations() {
            return this.mutations;
        }
    }

    public static class TabletLocation
    implements Comparable<TabletLocation> {
        private static final WeakHashMap<String, WeakReference<String>> tabletLocs = new WeakHashMap();
        public final KeyExtent tablet_extent;
        public final String tablet_location;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String dedupeLocation(String tabletLoc) {
            WeakHashMap<String, WeakReference<String>> weakHashMap = tabletLocs;
            synchronized (weakHashMap) {
                String loc;
                WeakReference<String> lref = tabletLocs.get(tabletLoc);
                if (lref != null && (loc = (String)lref.get()) != null) {
                    return loc;
                }
                tabletLoc = new String(tabletLoc);
                tabletLocs.put(tabletLoc, new WeakReference<String>(tabletLoc));
                return tabletLoc;
            }
        }

        public TabletLocation(KeyExtent tablet_extent, String tablet_location) {
            ArgumentChecker.notNull(tablet_extent, tablet_location);
            this.tablet_extent = tablet_extent;
            this.tablet_location = TabletLocation.dedupeLocation(tablet_location);
        }

        public boolean equals(Object o) {
            if (o instanceof TabletLocation) {
                TabletLocation otl = (TabletLocation)o;
                return this.tablet_extent.equals(otl.tablet_extent) && this.tablet_location.equals(otl.tablet_location);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashcode is not implemented for class " + this.getClass().toString());
        }

        public String toString() {
            return "(" + this.tablet_extent + "," + this.tablet_location + ")";
        }

        @Override
        public int compareTo(TabletLocation o) {
            int result = this.tablet_extent.compareTo(o.tablet_extent);
            if (result == 0) {
                result = this.tablet_location.compareTo(o.tablet_location);
            }
            return result;
        }
    }

    public static class TabletLocations {
        private final List<TabletLocation> locations;
        private final List<KeyExtent> locationless;

        public TabletLocations(List<TabletLocation> locations, List<KeyExtent> locationless) {
            this.locations = locations;
            this.locationless = locationless;
        }

        public List<TabletLocation> getLocations() {
            return this.locations;
        }

        public List<KeyExtent> getLocationless() {
            return this.locationless;
        }
    }

    private static class LocatorKey {
        String instanceId;
        Text tableName;

        LocatorKey(String instanceId, Text table) {
            this.instanceId = instanceId;
            this.tableName = table;
        }

        public int hashCode() {
            return this.instanceId.hashCode() + this.tableName.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LocatorKey) {
                return this.equals((LocatorKey)o);
            }
            return false;
        }

        public boolean equals(LocatorKey lk) {
            return this.instanceId.equals(lk.instanceId) && this.tableName.equals((Object)lk.tableName);
        }
    }
}

