/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class Writer {
    private static final Logger log = Logger.getLogger(Writer.class);
    private Instance instance;
    private TCredentials credentials;
    private Text table;

    public Writer(Instance instance, TCredentials credentials, Text table) {
        ArgumentChecker.notNull(instance, credentials, table);
        this.instance = instance;
        this.credentials = credentials;
        this.table = table;
    }

    public Writer(Instance instance, TCredentials credentials, String table) {
        this(instance, credentials, new Text(table));
    }

    private static void updateServer(Mutation m, KeyExtent extent, String server, TCredentials ai, AccumuloConfiguration configuration) throws TException, NotServingTabletException, ConstraintViolationException, AccumuloSecurityException {
        ArgumentChecker.notNull(m, extent, server, ai);
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(server, configuration);
            client.update(Tracer.traceInfo(), ai, extent.toThrift(), m.toThrift());
            return;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code);
        }
        catch (TTransportException e) {
            log.warn((Object)("Error connecting to " + server + ": " + (Object)((Object)e)));
            throw e;
        }
        finally {
            ThriftUtil.returnClient(client);
        }
    }

    public void update(Mutation m) throws AccumuloException, AccumuloSecurityException, ConstraintViolationException, TableNotFoundException {
        ArgumentChecker.notNull(m);
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        while (true) {
            TabletLocator.TabletLocation tabLoc;
            if ((tabLoc = TabletLocator.getInstance(this.instance, this.table).locateTablet(new Text(m.getRow()), false, true, this.credentials)) == null) {
                log.trace((Object)("No tablet location found for row " + new String(m.getRow())));
                UtilWaitThread.sleep(500L);
                continue;
            }
            try {
                Writer.updateServer(m, tabLoc.tablet_extent, tabLoc.tablet_location, this.credentials, this.instance.getConfiguration());
                return;
            }
            catch (NotServingTabletException e) {
                log.trace((Object)("Not serving tablet, server = " + tabLoc.tablet_location));
                TabletLocator.getInstance(this.instance, this.table).invalidateCache(tabLoc.tablet_extent);
            }
            catch (TException e) {
                log.error((Object)("error sending update to " + tabLoc.tablet_location + ": " + (Object)((Object)e)));
                TabletLocator.getInstance(this.instance, this.table).invalidateCache(tabLoc.tablet_extent);
            }
            UtilWaitThread.sleep(500L);
        }
    }
}

