/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.mapreduce.lib.util.OutputConfigurator;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AccumuloOutputFormat
extends OutputFormat<Text, Mutation> {
    private static final Class<?> CLASS = AccumuloOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        OutputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    protected static Boolean isConnectorInfoSet(JobContext context) {
        return OutputConfigurator.isConnectorInfoSet(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static String getPrincipal(JobContext context) {
        return OutputConfigurator.getPrincipal(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static String getTokenClass(JobContext context) {
        return OutputConfigurator.getTokenClass(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static byte[] getToken(JobContext context) {
        return OutputConfigurator.getToken(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setZooKeeperInstance(Job job, String instanceName, String zooKeepers) {
        OutputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), instanceName, zooKeepers);
    }

    public static void setMockInstance(Job job, String instanceName) {
        OutputConfigurator.setMockInstance(CLASS, job.getConfiguration(), instanceName);
    }

    protected static Instance getInstance(JobContext context) {
        return OutputConfigurator.getInstance(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setLogLevel(Job job, Level level) {
        OutputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext context) {
        return OutputConfigurator.getLogLevel(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setDefaultTableName(Job job, String tableName) {
        OutputConfigurator.setDefaultTableName(CLASS, job.getConfiguration(), tableName);
    }

    protected static String getDefaultTableName(JobContext context) {
        return OutputConfigurator.getDefaultTableName(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setBatchWriterOptions(Job job, BatchWriterConfig bwConfig) {
        OutputConfigurator.setBatchWriterOptions(CLASS, job.getConfiguration(), bwConfig);
    }

    protected static BatchWriterConfig getBatchWriterOptions(JobContext context) {
        return OutputConfigurator.getBatchWriterOptions(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setCreateTables(Job job, boolean enableFeature) {
        OutputConfigurator.setCreateTables(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static Boolean canCreateTables(JobContext context) {
        return OutputConfigurator.canCreateTables(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setSimulationMode(Job job, boolean enableFeature) {
        OutputConfigurator.setSimulationMode(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static Boolean getSimulationMode(JobContext context) {
        return OutputConfigurator.getSimulationMode(CLASS, InputFormatBase.getConfiguration(context));
    }

    public void checkOutputSpecs(JobContext job) throws IOException {
        if (!AccumuloOutputFormat.isConnectorInfoSet(job).booleanValue()) {
            throw new IOException("Connector info has not been set.");
        }
        try {
            Connector c = AccumuloOutputFormat.getInstance(job).getConnector(AccumuloOutputFormat.getPrincipal(job), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass(job), AccumuloOutputFormat.getToken(job)));
            if (!c.securityOperations().authenticateUser(AccumuloOutputFormat.getPrincipal(job), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass(job), AccumuloOutputFormat.getToken(job)))) {
                throw new IOException("Unable to authenticate user");
            }
        }
        catch (AccumuloException e) {
            throw new IOException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(TaskAttemptContext attempt) throws IOException {
        try {
            return new AccumuloRecordWriter(attempt);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public static void setOutputInfo(Configuration conf, String user, byte[] passwd, boolean createTables, String defaultTable) {
        try {
            OutputConfigurator.setConnectorInfo(CLASS, conf, user, new PasswordToken(passwd));
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
        OutputConfigurator.setCreateTables(CLASS, conf, createTables);
        OutputConfigurator.setDefaultTableName(CLASS, conf, defaultTable);
    }

    @Deprecated
    public static void setZooKeeperInstance(Configuration conf, String instanceName, String zooKeepers) {
        OutputConfigurator.setZooKeeperInstance(CLASS, conf, instanceName, zooKeepers);
    }

    @Deprecated
    public static void setMockInstance(Configuration conf, String instanceName) {
        OutputConfigurator.setMockInstance(CLASS, conf, instanceName);
    }

    @Deprecated
    public static void setMaxMutationBufferSize(Configuration conf, long numberOfBytes) {
        BatchWriterConfig bwConfig = OutputConfigurator.getBatchWriterOptions(CLASS, conf);
        bwConfig.setMaxMemory(numberOfBytes);
        OutputConfigurator.setBatchWriterOptions(CLASS, conf, bwConfig);
    }

    @Deprecated
    public static void setMaxLatency(Configuration conf, int numberOfMilliseconds) {
        BatchWriterConfig bwConfig = OutputConfigurator.getBatchWriterOptions(CLASS, conf);
        bwConfig.setMaxLatency(numberOfMilliseconds, TimeUnit.MILLISECONDS);
        OutputConfigurator.setBatchWriterOptions(CLASS, conf, bwConfig);
    }

    @Deprecated
    public static void setMaxWriteThreads(Configuration conf, int numberOfThreads) {
        BatchWriterConfig bwConfig = OutputConfigurator.getBatchWriterOptions(CLASS, conf);
        bwConfig.setMaxWriteThreads(numberOfThreads);
        OutputConfigurator.setBatchWriterOptions(CLASS, conf, bwConfig);
    }

    @Deprecated
    public static void setLogLevel(Configuration conf, Level level) {
        OutputConfigurator.setLogLevel(CLASS, conf, level);
    }

    @Deprecated
    public static void setSimulationMode(Configuration conf) {
        OutputConfigurator.setSimulationMode(CLASS, conf, true);
    }

    @Deprecated
    protected static String getPrincipal(Configuration conf) {
        return OutputConfigurator.getPrincipal(CLASS, conf);
    }

    @Deprecated
    protected static byte[] getToken(Configuration conf) {
        return OutputConfigurator.getToken(CLASS, conf);
    }

    @Deprecated
    protected static boolean canCreateTables(Configuration conf) {
        return OutputConfigurator.canCreateTables(CLASS, conf);
    }

    @Deprecated
    protected static String getDefaultTableName(Configuration conf) {
        return OutputConfigurator.getDefaultTableName(CLASS, conf);
    }

    @Deprecated
    protected static Instance getInstance(Configuration conf) {
        return OutputConfigurator.getInstance(CLASS, conf);
    }

    @Deprecated
    protected static long getMaxMutationBufferSize(Configuration conf) {
        return OutputConfigurator.getBatchWriterOptions(CLASS, conf).getMaxMemory();
    }

    @Deprecated
    protected static int getMaxLatency(Configuration conf) {
        return (int)OutputConfigurator.getBatchWriterOptions(CLASS, conf).getMaxLatency(TimeUnit.MILLISECONDS);
    }

    @Deprecated
    protected static int getMaxWriteThreads(Configuration conf) {
        return OutputConfigurator.getBatchWriterOptions(CLASS, conf).getMaxWriteThreads();
    }

    @Deprecated
    protected static Level getLogLevel(Configuration conf) {
        return OutputConfigurator.getLogLevel(CLASS, conf);
    }

    @Deprecated
    protected static boolean getSimulationMode(Configuration conf) {
        return OutputConfigurator.getSimulationMode(CLASS, conf);
    }

    protected static class AccumuloRecordWriter
    extends RecordWriter<Text, Mutation> {
        private MultiTableBatchWriter mtbw = null;
        private HashMap<Text, BatchWriter> bws = null;
        private Text defaultTableName = null;
        private boolean simulate = false;
        private boolean createTables = false;
        private long mutCount = 0L;
        private long valCount = 0L;
        private Connector conn;

        protected AccumuloRecordWriter(TaskAttemptContext context) throws AccumuloException, AccumuloSecurityException, IOException {
            Level l = AccumuloOutputFormat.getLogLevel((JobContext)context);
            if (l != null) {
                log.setLevel(AccumuloOutputFormat.getLogLevel((JobContext)context));
            }
            this.simulate = AccumuloOutputFormat.getSimulationMode((JobContext)context);
            this.createTables = AccumuloOutputFormat.canCreateTables((JobContext)context);
            if (this.simulate) {
                log.info((Object)"Simulating output only. No writes to tables will occur");
            }
            this.bws = new HashMap();
            String tname = AccumuloOutputFormat.getDefaultTableName((JobContext)context);
            Text text = this.defaultTableName = tname == null ? null : new Text(tname);
            if (!this.simulate) {
                this.conn = AccumuloOutputFormat.getInstance((JobContext)context).getConnector(AccumuloOutputFormat.getPrincipal((JobContext)context), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass((JobContext)context), AccumuloOutputFormat.getToken((JobContext)context)));
                this.mtbw = this.conn.createMultiTableBatchWriter(AccumuloOutputFormat.getBatchWriterOptions((JobContext)context));
            }
        }

        public void write(Text table, Mutation mutation) throws IOException {
            if (table == null || table.toString().isEmpty()) {
                table = this.defaultTableName;
            }
            if (!this.simulate && table == null) {
                throw new IOException("No table or default table specified. Try simulation mode next time");
            }
            ++this.mutCount;
            this.valCount += (long)mutation.size();
            this.printMutation(table, mutation);
            if (this.simulate) {
                return;
            }
            if (!this.bws.containsKey(table)) {
                try {
                    this.addTable(table);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
            }
            try {
                this.bws.get(table).addMutation(mutation);
            }
            catch (MutationsRejectedException e) {
                throw new IOException(e);
            }
        }

        public void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
            if (this.simulate) {
                log.info((Object)("Simulating adding table: " + tableName));
                return;
            }
            log.debug((Object)("Adding table: " + tableName));
            BatchWriter bw = null;
            String table = tableName.toString();
            if (this.createTables && !this.conn.tableOperations().exists(table)) {
                try {
                    this.conn.tableOperations().create(table);
                }
                catch (AccumuloSecurityException e) {
                    log.error((Object)("Accumulo security violation creating " + table), (Throwable)e);
                    throw e;
                }
                catch (TableExistsException e) {
                    // empty catch block
                }
            }
            try {
                bw = this.mtbw.getBatchWriter(table);
            }
            catch (TableNotFoundException e) {
                log.error((Object)("Accumulo table " + table + " doesn't exist and cannot be created."), (Throwable)e);
                throw new AccumuloException(e);
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (AccumuloSecurityException e) {
                throw e;
            }
            if (bw != null) {
                this.bws.put(tableName, bw);
            }
        }

        private int printMutation(Text table, Mutation m) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Table %s row key: %s", table, this.hexDump(m.getRow())));
                for (ColumnUpdate cu : m.getUpdates()) {
                    log.trace((Object)String.format("Table %s column: %s:%s", table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())));
                    log.trace((Object)String.format("Table %s security: %s", table, new ColumnVisibility(cu.getColumnVisibility()).toString()));
                    log.trace((Object)String.format("Table %s value: %s", table, this.hexDump(cu.getValue())));
                }
            }
            return m.getUpdates().size();
        }

        private String hexDump(byte[] ba) {
            StringBuilder sb = new StringBuilder();
            for (byte b : ba) {
                if (b > 32 && b < 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("x%02x", b));
            }
            return sb.toString();
        }

        public void close(TaskAttemptContext attempt) throws IOException, InterruptedException {
            block6: {
                log.debug((Object)("mutations written: " + this.mutCount + ", values written: " + this.valCount));
                if (this.simulate) {
                    return;
                }
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    if (e.getAuthorizationFailuresMap().size() >= 0) {
                        HashMap tables = new HashMap();
                        for (Map.Entry<KeyExtent, Set<SecurityErrorCode>> ke : e.getAuthorizationFailuresMap().entrySet()) {
                            HashSet secCodes = (HashSet)tables.get(ke.getKey().getTableId().toString());
                            if (secCodes == null) {
                                secCodes = new HashSet();
                                tables.put(ke.getKey().getTableId().toString(), secCodes);
                            }
                            secCodes.addAll(ke.getValue());
                        }
                        log.error((Object)("Not authorized to write to tables : " + tables));
                    }
                    if (e.getConstraintViolationSummaries().size() <= 0) break block6;
                    log.error((Object)("Constraint violations : " + e.getConstraintViolationSummaries().size()));
                }
            }
        }
    }
}

