/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class AuthInfo
implements TBase<AuthInfo, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("AuthInfo");
    private static final TField USER_FIELD_DESC = new TField("user", 11, 1);
    private static final TField PASSWORD_FIELD_DESC = new TField("password", 11, 2);
    private static final TField INSTANCE_ID_FIELD_DESC = new TField("instanceId", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String user;
    public ByteBuffer password;
    public String instanceId;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public AuthInfo() {
    }

    public AuthInfo(String user, ByteBuffer password, String instanceId) {
        this();
        this.user = user;
        this.password = password;
        this.instanceId = instanceId;
    }

    public AuthInfo(AuthInfo other) {
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetPassword()) {
            this.password = TBaseHelper.copyBinary((ByteBuffer)other.password);
        }
        if (other.isSetInstanceId()) {
            this.instanceId = other.instanceId;
        }
    }

    public AuthInfo deepCopy() {
        return new AuthInfo(this);
    }

    public void clear() {
        this.user = null;
        this.password = null;
        this.instanceId = null;
    }

    public String getUser() {
        return this.user;
    }

    public AuthInfo setUser(String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    public byte[] getPassword() {
        this.setPassword(TBaseHelper.rightSize((ByteBuffer)this.password));
        return this.password == null ? null : this.password.array();
    }

    public ByteBuffer bufferForPassword() {
        return this.password;
    }

    public AuthInfo setPassword(byte[] password) {
        this.setPassword(password == null ? (ByteBuffer)null : ByteBuffer.wrap(password));
        return this;
    }

    public AuthInfo setPassword(ByteBuffer password) {
        this.password = password;
        return this;
    }

    public void unsetPassword() {
        this.password = null;
    }

    public boolean isSetPassword() {
        return this.password != null;
    }

    public void setPasswordIsSet(boolean value) {
        if (!value) {
            this.password = null;
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AuthInfo setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public void unsetInstanceId() {
        this.instanceId = null;
    }

    public boolean isSetInstanceId() {
        return this.instanceId != null;
    }

    public void setInstanceIdIsSet(boolean value) {
        if (!value) {
            this.instanceId = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case PASSWORD: {
                if (value == null) {
                    this.unsetPassword();
                    break;
                }
                this.setPassword((ByteBuffer)value);
                break;
            }
            case INSTANCE_ID: {
                if (value == null) {
                    this.unsetInstanceId();
                    break;
                }
                this.setInstanceId((String)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case USER: {
                return this.getUser();
            }
            case PASSWORD: {
                return this.getPassword();
            }
            case INSTANCE_ID: {
                return this.getInstanceId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case USER: {
                return this.isSetUser();
            }
            case PASSWORD: {
                return this.isSetPassword();
            }
            case INSTANCE_ID: {
                return this.isSetInstanceId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof AuthInfo) {
            return this.equals((AuthInfo)that);
        }
        return false;
    }

    public boolean equals(AuthInfo that) {
        if (that == null) {
            return false;
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_password = this.isSetPassword();
        boolean that_present_password = that.isSetPassword();
        if (this_present_password || that_present_password) {
            if (!this_present_password || !that_present_password) {
                return false;
            }
            if (!this.password.equals(that.password)) {
                return false;
            }
        }
        boolean this_present_instanceId = this.isSetInstanceId();
        boolean that_present_instanceId = that.isSetInstanceId();
        if (this_present_instanceId || that_present_instanceId) {
            if (!this_present_instanceId || !that_present_instanceId) {
                return false;
            }
            if (!this.instanceId.equals(that.instanceId)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(AuthInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        AuthInfo typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetUser()).compareTo(typedOther.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)typedOther.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPassword()).compareTo(typedOther.isSetPassword());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPassword() && (lastComparison = TBaseHelper.compareTo((Comparable)this.password, (Comparable)typedOther.password)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInstanceId()).compareTo(typedOther.isSetInstanceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInstanceId() && (lastComparison = TBaseHelper.compareTo((String)this.instanceId, (String)typedOther.instanceId)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AuthInfo(");
        boolean first = true;
        sb.append("user:");
        if (this.user == null) {
            sb.append("null");
        } else {
            sb.append(this.user);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("password:");
        if (this.password == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.password, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("instanceId:");
        if (this.instanceId == null) {
            sb.append("null");
        } else {
            sb.append(this.instanceId);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new AuthInfoStandardSchemeFactory());
        schemes.put(TupleScheme.class, new AuthInfoTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PASSWORD, new FieldMetaData("password", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.INSTANCE_ID, new FieldMetaData("instanceId", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(AuthInfo.class, metaDataMap);
    }

    private static class AuthInfoTupleScheme
    extends TupleScheme<AuthInfo> {
        private AuthInfoTupleScheme() {
        }

        public void write(TProtocol prot, AuthInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetUser()) {
                optionals.set(0);
            }
            if (struct.isSetPassword()) {
                optionals.set(1);
            }
            if (struct.isSetInstanceId()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetPassword()) {
                oprot.writeBinary(struct.password);
            }
            if (struct.isSetInstanceId()) {
                oprot.writeString(struct.instanceId);
            }
        }

        public void read(TProtocol prot, AuthInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(1)) {
                struct.password = iprot.readBinary();
                struct.setPasswordIsSet(true);
            }
            if (incoming.get(2)) {
                struct.instanceId = iprot.readString();
                struct.setInstanceIdIsSet(true);
            }
        }
    }

    private static class AuthInfoTupleSchemeFactory
    implements SchemeFactory {
        private AuthInfoTupleSchemeFactory() {
        }

        public AuthInfoTupleScheme getScheme() {
            return new AuthInfoTupleScheme();
        }
    }

    private static class AuthInfoStandardScheme
    extends StandardScheme<AuthInfo> {
        private AuthInfoStandardScheme() {
        }

        public void read(TProtocol iprot, AuthInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.password = iprot.readBinary();
                            struct.setPasswordIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.instanceId = iprot.readString();
                            struct.setInstanceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, AuthInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.user != null) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.password != null) {
                oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
                oprot.writeBinary(struct.password);
                oprot.writeFieldEnd();
            }
            if (struct.instanceId != null) {
                oprot.writeFieldBegin(INSTANCE_ID_FIELD_DESC);
                oprot.writeString(struct.instanceId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class AuthInfoStandardSchemeFactory
    implements SchemeFactory {
        private AuthInfoStandardSchemeFactory() {
        }

        public AuthInfoStandardScheme getScheme() {
            return new AuthInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        USER(1, "user"),
        PASSWORD(2, "password"),
        INSTANCE_ID(3, "instanceId");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return USER;
                }
                case 2: {
                    return PASSWORD;
                }
                case 3: {
                    return INSTANCE_ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

