/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

public class Duration {
    public static String format(long time) {
        return Duration.format(time, "&nbsp;");
    }

    public static String format(long time, String space) {
        return Duration.format(time, space, "&mdash;");
    }

    public static String format(long time, String space, String zero) {
        long yr = -1L;
        long day = -1L;
        long hr = -1L;
        long min = -1L;
        long sec = -1L;
        long ms = -1L;
        if (time == 0L) {
            return zero;
        }
        ms = time % 1000L;
        if ((time /= 1000L) == 0L) {
            return String.format("%dms", ms);
        }
        sec = time % 60L;
        if ((time /= 60L) == 0L) {
            return String.format("%ds" + space + "%dms", sec, ms);
        }
        min = time % 60L;
        if ((time /= 60L) == 0L) {
            return String.format("%dm" + space + "%ds", min, sec);
        }
        hr = time % 24L;
        if ((time /= 24L) == 0L) {
            return String.format("%dh" + space + "%dm", hr, min);
        }
        day = time % 365L;
        if ((time /= 365L) == 0L) {
            return String.format("%dd" + space + "%dh", day, hr);
        }
        yr = time;
        return String.format("%dy" + space + "%dd", yr, day);
    }
}

